/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestObjectMethods {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testToString() {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((String)dao.toString()).contains(new CharSequence[]{DAO.class.getName()});
    }

    @Test
    public void testEquals() {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((Object)dao).isEqualTo((Object)dao);
    }

    @Test
    public void testNotEquals() {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        DAO oad = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((Object)dao).isNotEqualTo((Object)oad);
    }

    @Test
    public void testHashCodeDiff() {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        DAO oad = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((int)dao.hashCode()).isNotEqualTo(oad.hashCode());
    }

    @Test
    public void testHashCodeMatch() {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((int)dao.hashCode()).isEqualTo(dao.hashCode());
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface DAO {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

