/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestOnDemandObjectMethodBehavior {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testFinalizeDoesntConnect() {
        Handle handle = (Handle)Mockito.spy((Object)this.h2Extension.getSharedHandle());
        UselessDao dao = (UselessDao)handle.attach(UselessDao.class);
        dao.finalize();
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.never())).getConnection();
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.never())).getJdbi();
    }

    public static interface UselessDao
    extends SqlObject {
        public void finalize();
    }
}

