/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.customizer.MaxRows;
import org.jdbi.v3.sqlobject.locator.UseClasspathSqlLocator;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.subpackage.BrokenDao;
import org.jdbi.v3.sqlobject.subpackage.SomethingDao;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSqlObject {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testPassThroughMethod() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.insert(3, "Cora");
        Something c = dao.findByIdHeeHee(3);
        Assertions.assertThat((Object)c).isEqualTo((Object)new Something(3, "Cora"));
    }

    @Test
    public void testUnimplementedMethod() {
        UnimplementedDao dao = (UnimplementedDao)this.handle.attach(UnimplementedDao.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> dao.totallyBroken()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Method UnimplementedDao.totallyBroken has no registered extension handler!");
    }

    @Test
    public void testRedundantMethodHasDefaultImplementAndAlsoSqlMethodAnnotation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.handle.attach(RedundantDao.class)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Default method RedundantDao.list has @SqlQuery annotation. Extension type methods may be default, or have a @UseExtensionHandler annotation, but not both.");
    }

    @Test
    public void testPassThroughMethodWithDaoInAnotherPackage() {
        SomethingDao dao = (SomethingDao)this.handle.attach(SomethingDao.class);
        dao.insert(3, "Cora");
        Something c = dao.findByIdHeeHee(3);
        Assertions.assertThat((Object)c).isEqualTo((Object)new Something(3, "Cora"));
    }

    @Test
    public void testUnimplementedMethodWithDaoInAnotherPackage() {
        BrokenDao dao = (BrokenDao)this.handle.attach(BrokenDao.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> dao.totallyBroken()).isInstanceOf(IllegalStateException.class)).hasMessage("Method BrokenDao.totallyBroken has no registered extension handler!");
    }

    @Test
    public void testSimpleTransactionsSucceed() {
        SomethingDao dao = (SomethingDao)this.h2Extension.getJdbi().onDemand(SomethingDao.class);
        Assertions.assertThat((int)dao.insertInSingleTransaction(10, "Linda")).isOne();
    }

    @Test
    public void testTransactionAnnotationWorksOnInterfaceDefaultMethod() {
        Dao dao = (Dao)this.h2Extension.getSharedHandle().attach(Dao.class);
        Assertions.assertThat((boolean)dao.doesTransactionAnnotationWork()).isTrue();
    }

    @Test
    public void testNestedTransactionsCollapseIntoSingleTransaction() {
        Handle spyHandle = (Handle)Mockito.spy((Object)this.h2Extension.getSharedHandle());
        Dao dao = (Dao)spyHandle.attach(Dao.class);
        dao.threeNestedTransactions();
        ((Handle)Mockito.verify((Object)spyHandle, (VerificationMode)Mockito.times((int)1))).begin();
        ((Handle)Mockito.verify((Object)spyHandle, (VerificationMode)Mockito.times((int)1))).commit();
        dao.twoNestedTransactions();
        ((Handle)Mockito.verify((Object)spyHandle, (VerificationMode)Mockito.times((int)2))).begin();
        ((Handle)Mockito.verify((Object)spyHandle, (VerificationMode)Mockito.times((int)2))).commit();
    }

    @Test
    public void testNestedTransactionWithSameIsolation() {
        Handle spyHandle = (Handle)Mockito.spy((Object)this.h2Extension.getSharedHandle());
        Dao dao = (Dao)spyHandle.attach(Dao.class);
        dao.nestedTransactionWithSameIsolation();
        ((Handle)Mockito.verify((Object)spyHandle, (VerificationMode)Mockito.times((int)1))).begin();
        ((Handle)Mockito.verify((Object)spyHandle, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void testNestedTransactionWithDifferentIsoltion() {
        Handle spyHandle = (Handle)Mockito.spy((Object)this.h2Extension.getSharedHandle());
        Dao dao = (Dao)spyHandle.attach(Dao.class);
        Assertions.assertThatThrownBy(dao::nestedTransactionWithDifferentIsolation).isInstanceOf(TransactionException.class);
    }

    @Test
    public void testSqlUpdateWithTransaction() {
        Handle spyHandle = (Handle)Mockito.spy((Object)this.h2Extension.getSharedHandle());
        Dao dao = (Dao)spyHandle.attach(Dao.class);
        dao.insert(1, "foo");
        ((Handle)Mockito.verify((Object)spyHandle, (VerificationMode)Mockito.never())).begin();
        Assertions.assertThat((Object)dao.findById(1)).isEqualTo((Object)new Something(1, "foo"));
        Assertions.assertThat((Integer)dao.insertTransactional(2, "bar")).isOne();
        ((Handle)Mockito.verify((Object)spyHandle, (VerificationMode)Mockito.times((int)1))).begin();
        Assertions.assertThat((Object)dao.findById(2)).isEqualTo((Object)new Something(2, "bar"));
    }

    @Test
    public void testDefaultMethodCustomizingAnnotation() {
        AnnotatedDefaultMethodDao dao = (AnnotatedDefaultMethodDao)this.handle.attach(AnnotatedDefaultMethodDao.class);
        Assertions.assertThat(dao.annotatedMethod()).isEmpty();
    }

    @Test
    public void testDefaultMethodParameterDefineAnnotation() {
        AnnotatedDefaultMethodDao dao = (AnnotatedDefaultMethodDao)this.handle.attach(AnnotatedDefaultMethodDao.class);
        Assertions.assertThat(dao.annotatedDefineParameter(20)).isEmpty();
    }

    @Test
    public void testDefaultMethodParameterBindAnnotation() {
        AnnotatedDefaultMethodDao dao = (AnnotatedDefaultMethodDao)this.handle.attach(AnnotatedDefaultMethodDao.class);
        Assertions.assertThat((String)dao.annotatedBindParameter(20)).isEqualTo("foo");
    }

    @Test
    public void testBooleanReturn() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Assertions.assertThat((boolean)dao.insert(1, "a")).isTrue();
        Assertions.assertThat((boolean)dao.update(2, "b")).isFalse();
    }

    @Test
    public void testSubInterfaceOverridesSuperMethods() {
        SubclassDao dao = (SubclassDao)this.handle.attach(SubclassDao.class);
        dao.insert(new Something(1, "foo"));
        Assertions.assertThat((Object)dao.get(1L)).isEqualTo((Object)new Something(1, "foo"));
    }

    @Test
    public void testStaticMethod() {
        this.handle.attach(StaticDao.class);
        Assertions.assertThat((int)StaticDao.staticMethod()).isEqualTo(42);
    }

    @Test
    public void genericSuperclassExtendedByExplicitTypedSubclass() {
        ExtendGenericDaoWithExplicitParameter dao = (ExtendGenericDaoWithExplicitParameter)this.handle.attach(ExtendGenericDaoWithExplicitParameter.class);
        Something alice = new Something(1, "Alice");
        Something bob = new Something(2, "Bob");
        dao.batchInsert(Arrays.asList(alice, bob));
        Assertions.assertThat(dao.list()).containsExactly((Object[])new Something[]{alice, bob});
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Dao
    extends SqlObject {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public boolean insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlUpdate(value="update something set name=:name where id=:id")
        public boolean update(int var1, String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        @Transaction
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public Integer insertTransactional(@Bind(value="id") int var1, @Bind(value="name") String var2);

        default public Something findByIdHeeHee(int id) {
            return this.findById(id);
        }

        @Transaction
        default public void threeNestedTransactions() {
            this.twoNestedTransactions();
        }

        @Transaction
        default public void twoNestedTransactions() {
            Assertions.assertThat((boolean)this.doesTransactionAnnotationWork()).isTrue();
        }

        @Transaction
        default public boolean doesTransactionAnnotationWork() {
            return this.getHandle().isInTransaction();
        }

        @Transaction(value=TransactionIsolationLevel.READ_UNCOMMITTED)
        default public boolean transactionWithIsolation() {
            return this.getHandle().isInTransaction();
        }

        @Transaction(value=TransactionIsolationLevel.READ_UNCOMMITTED)
        default public void nestedTransactionWithSameIsolation() {
            Assertions.assertThat((boolean)this.transactionWithIsolation()).isTrue();
        }

        @Transaction(value=TransactionIsolationLevel.READ_COMMITTED)
        default public void nestedTransactionWithDifferentIsolation() {
            this.transactionWithIsolation();
        }
    }

    public static interface UnimplementedDao
    extends SqlObject {
        public void totallyBroken();
    }

    public static interface AnnotatedDefaultMethodDao
    extends SqlObject {
        @MaxRows(value=10)
        default public List<String> annotatedMethod() {
            return Collections.emptyList();
        }

        default public List<String> annotatedDefineParameter(@Define int wut) {
            return Collections.emptyList();
        }

        default public String annotatedBindParameter(@Bind int wat) {
            return "foo";
        }
    }

    public static interface SubclassDao
    extends BaseDao<Something> {
        @Override
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @Override
        @SqlQuery(value="select * from something where id = :id")
        @RegisterBeanMapper(value=Something.class)
        public Something get(long var1);
    }

    public static interface StaticDao
    extends SqlObject {
        public static int staticMethod() {
            return 42;
        }
    }

    @RegisterBeanMapper(value=Something.class)
    public static interface ExtendGenericDaoWithExplicitParameter
    extends GenericDao<Something> {
    }

    public static interface RedundantDao
    extends SqlObject {
        @SqlQuery(value="select * from something")
        @RegisterRowMapper(value=SomethingMapper.class)
        default public List<Something> list() {
            return this.getHandle().createQuery("select * from something").map((RowMapper)new SomethingMapper()).list();
        }
    }

    @UseClasspathSqlLocator
    public static interface GenericDao<T> {
        @SqlBatch
        public void batchInsert(@BindBean Collection<T> var1);

        @SqlQuery
        public List<T> list();
    }

    public static interface BaseDao<T> {
        public void insert(T var1);

        public T get(long var1);
    }
}

