/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionContext;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSqlObjectMethodBehavior {
    private Jdbi jdbi;
    private UselessDao dao;
    private UselessDao anotherDao;

    @BeforeEach
    public void setUp() {
        this.jdbi = Jdbi.create(() -> {
            throw new UnsupportedOperationException();
        });
        this.jdbi.registerExtension((ExtensionFactory)new SqlObjectFactory());
        HandleSupplier handleSupplier = new HandleSupplier(){

            public ConfigRegistry getConfig() {
                return new ConfigRegistry();
            }

            public Handle getHandle() {
                throw new UnsupportedOperationException();
            }

            public Jdbi getJdbi() {
                throw new UnsupportedOperationException();
            }

            public <V> V invokeInContext(ExtensionContext extensionContext, Callable<V> task) throws Exception {
                return task.call();
            }
        };
        ExtensionFactory factory = ((Extensions)this.jdbi.getConfig(Extensions.class)).findFactory(SqlObjectFactory.class).orElseGet(() -> (ExtensionFactory)Assertions.fail((String)"Could not retrieve factory"));
        this.dao = (UselessDao)factory.attach(UselessDao.class, handleSupplier);
        this.anotherDao = (UselessDao)factory.attach(UselessDao.class, handleSupplier);
    }

    @Test
    public void testFinalizeDoesntConnect() {
        try {
            this.dao.finalize();
        }
        catch (UnsupportedOperationException e) {
            Assertions.fail((String)"should not open a connection");
        }
    }

    @Test
    public void testEquals() {
        ((ObjectAssert)Assertions.assertThat((Object)this.dao).isEqualTo((Object)this.dao)).isNotEqualTo((Object)this.anotherDao);
    }

    @Test
    public void testHashCode() {
        ((ObjectAssert)Assertions.assertThat((Object)this.dao).hasSameHashCodeAs((Object)this.dao)).doesNotHaveSameHashCodeAs((Object)this.anotherDao);
    }

    @Test
    public void testToStringDoesntConnect() {
        try {
            this.dao.toString();
        }
        catch (UnsupportedOperationException e) {
            Assertions.fail((String)"should not open a connection");
        }
    }

    public static interface UselessDao
    extends SqlObject {
        public void finalize();
    }
}

