/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TimingCollector;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.BatchChunkSize;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlCall;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestTimingCollector {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().installPlugins().withInitializer(TestingInitializers.something());
    private final CustomTimingCollector timingCollector = new CustomTimingCollector();
    private DAO dao;
    private Jdbi db;

    @BeforeEach
    public void setUp() {
        this.db = this.h2Extension.getJdbi();
        this.db.useHandle(h -> h.execute("CREATE ALIAS custom_insert FOR \"org.jdbi.v3.sqlobject.TestTimingCollector.customInsert\";", new Object[0]));
        this.db.setTimingCollector((TimingCollector)this.timingCollector);
        this.dao = (DAO)this.db.onDemand(DAO.class);
    }

    @Test
    public void testInsert() {
        this.dao.insert(1, "Brian");
        this.dao.insert(2, "Jeff");
        Assertions.assertThat((Collection)this.timingCollector.statementNames).containsExactly((Object[])new String[]{"org.jdbi.v3.sqlobject.DAO.insert"});
    }

    @Test
    public void testInsertBatch() {
        this.dao.insertBatch(Arrays.asList(1, 2, 3), Arrays.asList("Mary", "David", "Kate"));
        Assertions.assertThat((Collection)this.timingCollector.statementNames).containsOnly((Object[])new String[]{"org.jdbi.v3.sqlobject.DAO.insertBatch"});
    }

    @Test
    public void testCustomInsert() {
        this.dao.customInsert(1, "Robb");
        this.dao.customInsert(2, "Greg");
        Assertions.assertThat((Collection)this.timingCollector.statementNames).containsOnly((Object[])new String[]{"org.jdbi.v3.sqlobject.DAO.customInsert"});
    }

    @Test
    public void testSqlQuery() {
        AdvancedDAO advancedDAO = (AdvancedDAO)this.db.onDemand(AdvancedDAO.class);
        advancedDAO.insertBatch(Arrays.asList(1, 2, 3), Arrays.asList("Mary", "David", "Kate"));
        String name = advancedDAO.findNameById(3);
        Assertions.assertThat((String)name).isEqualTo("Kate");
        Assertions.assertThat((Collection)this.timingCollector.statementNames).containsOnly((Object[])new String[]{"org.jdbi.v3.sqlobject.AdvancedDAO.insertBatch", "org.jdbi.v3.sqlobject.AdvancedDAO.findNameById"});
    }

    @Test
    public void testRawSql() {
        this.db.useHandle(h -> {
            PreparedBatch batch = h.prepareBatch("insert into something (id, name) values (?, ?)");
            batch.add(new Object[]{1, "Mary"});
            batch.add(new Object[]{2, "David"});
            batch.add(new Object[]{3, "Kate"});
            batch.execute();
        });
        List names = (List)this.db.withHandle(h -> h.createQuery("select name from something order by name").mapTo(String.class).list());
        Assertions.assertThat((List)names).containsExactly((Object[])new String[]{"David", "Kate", "Mary"});
        Assertions.assertThat((Collection)this.timingCollector.statementNames).containsOnly((Object[])new String[]{"sql.raw.insert into something (id, name) values (?, ?)", "sql.raw.select name from something order by name"});
    }

    public static int customInsert(Connection conn, int id, String name) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("insert into something (id, name) values (?, ?)");
        stmt.setInt(1, id);
        stmt.setString(2, name);
        return stmt.executeUpdate();
    }

    private static class CustomTimingCollector
    implements TimingCollector {
        private final Set<String> statementNames = new HashSet<String>();
        private final SqlObjectStrategy statementNameStrategy = new SqlObjectStrategy();

        private CustomTimingCollector() {
        }

        public void collect(long elapsedTime, StatementContext ctx) {
            this.statementNames.add(this.statementNameStrategy.getStatementName(ctx));
        }
    }

    public static interface DAO {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        @BatchChunkSize(value=2)
        public void insertBatch(@Bind(value="id") List<Integer> var1, @Bind(value="name") List<String> var2);

        @SqlCall(value="call custom_insert(:id, :name)")
        public void customInsert(@Bind(value="id") int var1, @Bind(value="name") String var2);
    }

    public static interface AdvancedDAO
    extends DAO {
        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }

    private static class SqlObjectStrategy {
        private SqlObjectStrategy() {
        }

        String getStatementName(StatementContext statementContext) {
            ExtensionMethod extensionMethod = statementContext.getExtensionMethod();
            if (extensionMethod != null) {
                Class type = extensionMethod.getType();
                Method method = extensionMethod.getMethod();
                String group = type.getPackage().getName();
                String name = type.getSimpleName();
                return group + "." + name + "." + method.getName();
            }
            return "sql.raw." + statementContext.getRawSql();
        }
    }
}

