/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.core.transaction.UnableToManipulateTransactionIsolationLevelException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.JdbiH2Extension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestTransactional {
    @RegisterExtension
    public JdbiExtension h2Extension = new JdbiH2Extension(){

        protected DataSource createDataSource() {
            return new DataSourceWrapper(super.createDataSource(), c -> TestTransactional.this.createProxyHandler(c));
        }
    }.withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi jdbi;
    private final AtomicBoolean inTransaction = new AtomicBoolean();
    private static final Set<Method> CHECKED_METHODS;

    @BeforeEach
    public void setUp() {
        this.jdbi = this.h2Extension.getJdbi();
    }

    @Test
    public void testDoublyTransactional() {
        TheBasics dao = (TheBasics)this.jdbi.onDemand(TheBasics.class);
        dao.inTransaction(TransactionIsolationLevel.SERIALIZABLE, transactional -> {
            transactional.insert(new Something(1, "2"));
            this.inTransaction.set(true);
            transactional.insert(new Something(2, "3"));
            this.inTransaction.set(false);
            return null;
        });
        Assertions.assertThat((int)dao.count()).isEqualTo(2);
    }

    @Test
    public void testCrashWithHandler() {
        TheBasics dao = (TheBasics)this.jdbi.onDemand(TheBasics.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> dao.inTransaction(TransactionIsolationLevel.SERIALIZABLE, transactional -> {
            this.inTransaction.set(true);
            transactional.getHandle().setTransactionIsolationLevel(TransactionIsolationLevel.READ_COMMITTED);
            transactional.insert(new Something(2, "3"));
            this.inTransaction.set(false);
            return null;
        })).isInstanceOf(UnableToManipulateTransactionIsolationLevelException.class)).hasCauseInstanceOf(SQLException.class).extracting(ex -> ex.getCause().getMessage()).isEqualTo((Object)"PostgreSQL would not let you set the transaction isolation here");
    }

    @Test
    public void testOnDemandBeginTransaction() {
        Assertions.assertThatThrownBy(() -> ((Transactional)((Transactional)this.jdbi.onDemand(Transactional.class))).begin()).isInstanceOf(TransactionException.class);
    }

    @Test
    public void testTypeDecorator() {
        Assertions.assertThat((boolean)((AlwaysTransactional)this.jdbi.onDemand(AlwaysTransactional.class)).isInTransaction()).isTrue();
    }

    @Test
    public void testUseAttachRollback() {
        Assertions.assertThatThrownBy(() -> this.jdbi.useTransaction(handle -> {
            ((InserterDao)handle.attach(InserterDao.class)).insert();
            throw new Exception();
        })).isOfAnyClassIn(new Class[]{Exception.class});
        Assertions.assertThat((List)((List)this.jdbi.inTransaction(handle -> ((InserterDao)handle.attach(InserterDao.class)).list()))).isEmpty();
    }

    @Test
    public void testNestedTransactionCallbacks() {
        AtomicBoolean result = new AtomicBoolean();
        CommitCallbackDao dao = (CommitCallbackDao)this.jdbi.onDemand(CommitCallbackDao.class);
        this.jdbi.useTransaction(txn -> dao.txnCommitSet(() -> result.set(true)));
        Assertions.assertThat((AtomicBoolean)result).isTrue();
    }

    private Connection createProxyHandler(Connection real) {
        return (Connection)Proxy.newProxyInstance(real.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new TxnIsolationCheckingInvocationHandler(real));
    }

    static {
        try {
            CHECKED_METHODS = ImmutableSet.of((Object)Connection.class.getMethod("setTransactionIsolation", Integer.TYPE));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static interface TheBasics
    extends Transactional<TheBasics> {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        @Transaction(value=TransactionIsolationLevel.SERIALIZABLE)
        public int insert(@BindBean Something var1);

        @SqlQuery(value="select count(1) from something")
        public int count();
    }

    @Transaction
    public static interface AlwaysTransactional
    extends SqlObject {
        default public boolean isInTransaction() {
            return this.getHandle().isInTransaction();
        }
    }

    public static interface CommitCallbackDao
    extends SqlObject {
        @Transaction
        default public void txnCommitSet(Runnable action) {
            this.getHandle().afterCommit(action);
        }
    }

    private class TxnIsolationCheckingInvocationHandler
    implements InvocationHandler {
        private final Connection real;

        TxnIsolationCheckingInvocationHandler(Connection real) {
            this.real = real;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (CHECKED_METHODS.contains(method) && TestTransactional.this.inTransaction.get()) {
                throw new SQLException("PostgreSQL would not let you set the transaction isolation here");
            }
            return method.invoke((Object)this.real, args);
        }
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface InserterDao {
        @SqlUpdate(value="insert into something(id, name) values(1, 'test')")
        public int insert();

        @SqlQuery(value="select * from something")
        public List<Something> list();
    }

    class DataSourceWrapper
    implements DataSource {
        private final DataSource delegate;
        private final Function<Connection, Connection> transformer;

        DataSourceWrapper(DataSource delegate, Function<Connection, Connection> transformer) {
            this.delegate = delegate;
            this.transformer = transformer;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.transformer.apply(this.delegate.getConnection());
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.transformer.apply(this.delegate.getConnection(username, password));
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.delegate.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.delegate.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.delegate.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.delegate.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.delegate.getParentLogger();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegate.isWrapperFor(iface);
        }
    }
}

