/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.ColonPrefixSqlParser;
import org.jdbi.v3.core.statement.HashPrefixSqlParser;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.config.UseSqlParser;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestUseSqlParser {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        Jdbi db = this.h2Extension.getJdbi();
        db.setSqlParser((SqlParser)new ColonPrefixSqlParser());
        this.handle = db.open();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testFoo() {
        Hashed h = (Hashed)this.handle.attach(Hashed.class);
        h.insert(new Something(1, "Joy"));
        Something s = h.findById(1);
        Assertions.assertThat((String)s.getName()).isEqualTo("Joy");
    }

    @UseSqlParser(value=HashPrefixSqlParser.class)
    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Hashed {
        @SqlUpdate(value="insert into something (id, name) values (#id, #name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select id, name from something where id = #id")
        public Something findById(@Bind(value="id") int var1);
    }
}

