/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.UnableToCreateExtensionException;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.KeyColumn;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MapResultTest {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin()});
    Jdbi jdbi;
    UUID content;

    @BeforeEach
    void setUp() {
        this.jdbi = this.pgExtension.getJdbi();
        this.jdbi.registerRowMapper(JsonBean.class, ConstructorMapper.of(JsonBean.class));
        this.jdbi.useHandle(handle -> handle.execute("CREATE TABLE json_data (id INTEGER PRIMARY KEY, key VARCHAR, value UUID)", new Object[0]));
        this.content = UUID.randomUUID();
        this.jdbi.withHandle(handle -> handle.execute("INSERT INTO json_data (id, key, value) VALUES (?, ?, ?)", new Object[]{1, "test", this.content}));
    }

    @Test
    public void testBadMethodFails() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.jdbi.withExtension(MapDao.class, dao -> dao.getValuesMissingAnnotation(1))).isInstanceOf(NoSuchMapperException.class)).hasMessageContaining("Map key column is not declared (missing @KeyColumn annotation?) and no row mapper for key type 'class java.lang.String' is registered!");
    }

    @Test
    public void testGoodMethodWorksByDefault() {
        Map result = (Map)this.jdbi.withExtension(MapDao.class, dao -> dao.getValues(1));
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasSize(1);
        JsonBean bean = (JsonBean)result.get("test");
        ((ObjectAssert)Assertions.assertThat((Object)bean).isNotNull()).extracting("id").isEqualTo((Object)1);
        Assertions.assertThat((Object)bean).extracting("key").isEqualTo((Object)"test");
        Assertions.assertThat((Object)bean).extracting("value").isEqualTo((Object)this.content);
    }

    @Test
    public void testGoodMethodFailsWhenRequested() {
        this.jdbi.configure(Extensions.class, Extensions::failFast);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.jdbi.withExtension(MapDao.class, dao -> dao.getValues(1))).isInstanceOf(UnableToCreateExtensionException.class)).hasMessageContaining("getValuesMissingAnnotation").hasMessageContaining("Map key column is not declared (missing @KeyColumn annotation?) and no row mapper for key type 'class java.lang.String' is registered!");
    }

    public static final class JsonBean {
        private final int id;
        private final String key;
        private final UUID value;

        public JsonBean(int id, String key, UUID value) {
            this.id = id;
            this.key = key;
            this.value = value;
        }

        public int getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public UUID getValue() {
            return this.value;
        }
    }

    public static interface MapDao {
        @SqlQuery(value="SELECT * FROM json_data WHERE id = :id")
        @KeyColumn(value="key")
        public Map<String, JsonBean> getValues(int var1);

        @SqlQuery(value="SELECT * FROM json_data WHERE id = :id")
        public Map<String, JsonBean> getValuesMissingAnnotation(int var1);
    }
}

