/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.MockClock;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Timestamped;
import org.jdbi.v3.sqlobject.customizer.TimestampedConfig;
import org.jdbi.v3.sqlobject.customizer.internal.TimestampedFactory;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestTimestamped {
    private static final ZoneOffset GMT_PLUS_2 = ZoneOffset.ofHours(2);
    private static final OffsetDateTime UTC_MOMENT = OffsetDateTime.of(LocalDate.of(2018, Month.JANUARY, 1), LocalTime.NOON, ZoneOffset.UTC);
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private PersonDAO personDAO;
    private static ThreadLocal<String> logNext = new ThreadLocal();
    private static ThreadLocal<OffsetDateTime> insertedTimestamp = new ThreadLocal();
    private final MockClock clock = MockClock.at(UTC_MOMENT.toZonedDateTime());

    @BeforeEach
    public void before() {
        TimestampedFactory.setTimeSource(this.clock::withZone);
        Jdbi db = this.h2Extension.getJdbi();
        ((TimestampedConfig)db.getConfig(TimestampedConfig.class)).setTimezone((ZoneId)GMT_PLUS_2);
        db.setSqlLogger(new SqlLogger(){

            public void logBeforeExecution(StatementContext ctx) {
                String name = (String)logNext.get();
                if (name != null) {
                    String toString = ((Argument)ctx.getBinding().findForName(name, ctx).orElseThrow(AssertionError::new)).toString();
                    insertedTimestamp.set(OffsetDateTime.parse(toString));
                    logNext.set(null);
                }
            }
        });
        this.personDAO = (PersonDAO)db.onDemand(PersonDAO.class);
        this.personDAO.createTable();
    }

    @Test
    public void shouldInsertCreatedAndModifiedFields() {
        Person input = new Person("John", "Phiri");
        input.setId(1);
        logNext.set("now");
        this.personDAO.insert(input);
        Assertions.assertThat((Comparable)insertedTimestamp.get().getOffset()).isEqualTo((Object)GMT_PLUS_2);
        Assertions.assertThat((Instant)insertedTimestamp.get().toInstant()).isEqualTo((Object)UTC_MOMENT.toInstant());
        Person result = this.personDAO.get(1);
        ((AbstractDateAssert)Assertions.assertThat((Date)result.getCreated()).isEqualTo((Object)result.getModified())).isEqualTo((Object)TestTimestamped.insertedSqlTimestamp());
    }

    @Test
    public void shouldAllowCustomTimestampParameter() {
        Person input = new Person("John", "Phiri");
        input.setId(1);
        logNext.set("createdAt");
        this.personDAO.insertWithCustomTimestampFields(input);
        Assertions.assertThat((Comparable)insertedTimestamp.get().getOffset()).isEqualTo((Object)GMT_PLUS_2);
        Assertions.assertThat((Instant)insertedTimestamp.get().toInstant()).isEqualTo((Object)UTC_MOMENT.toInstant());
        Person result = this.personDAO.get(1);
        Assertions.assertThat((String)result.getFirstName()).isEqualTo(input.getFirstName());
        Assertions.assertThat((String)result.getLastName()).isEqualTo(input.getLastName());
        ((AbstractDateAssert)Assertions.assertThat((Date)result.getCreated()).isEqualTo((Object)result.getModified())).isEqualTo((Object)TestTimestamped.insertedSqlTimestamp());
    }

    @Test
    public void shouldUpdateModifiedTimestamp() {
        Person input = new Person("John", "Phiri");
        input.setId(3);
        logNext.set("now");
        this.personDAO.insert(input);
        Timestamp insert = TestTimestamped.insertedSqlTimestamp();
        Person fetched = this.personDAO.get(3);
        fetched.setLastName("Banda");
        this.clock.advance(1L, ChronoUnit.SECONDS);
        logNext.set("now");
        this.personDAO.updatePerson(fetched);
        Timestamp update = TestTimestamped.insertedSqlTimestamp();
        Person result = this.personDAO.get(3);
        Assertions.assertThat((Date)insert).isNotEqualTo((Object)update);
        Assertions.assertThat((String)result.getLastName()).isEqualToIgnoringCase((CharSequence)"Banda");
        Assertions.assertThat((Date)result.getCreated()).isEqualTo((Object)insert);
        Assertions.assertThat((Date)result.getModified()).isEqualTo((Object)update);
    }

    private static Timestamp insertedSqlTimestamp() {
        return Timestamp.from(insertedTimestamp.get().toInstant());
    }

    @RegisterRowMapper(value=PersonRowMapper.class)
    public static interface PersonDAO {
        @SqlUpdate(value="CREATE TABLE people(id identity primary key, firstName varchar(50), lastName varchar(50), created timestamp, modified timestamp);")
        public void createTable();

        @GetGeneratedKeys
        @SqlUpdate(value="INSERT INTO people(id, firstName, lastName, created, modified) VALUES (:p.id, :p.firstName, :p.lastName, :now, :now)")
        @Timestamped
        public int insert(@BindBean(value="p") Person var1);

        @SqlUpdate(value="INSERT INTO people(id, firstName, lastName, created, modified) VALUES (:p.id, :p.firstName, :p.lastName, :createdAt, :createdAt)")
        @Timestamped(value="createdAt")
        public int insertWithCustomTimestampFields(@BindBean(value="p") Person var1);

        @SqlUpdate(value="UPDATE people SET firstName = :p.firstName, lastName = :p.lastName, modified = :now WHERE id = :p.id")
        @Timestamped
        public int updatePerson(@BindBean(value="p") Person var1);

        @SqlQuery(value="SELECT id, firstName, lastName, created, modified from people WHERE id=:id")
        public Person get(@Bind(value="id") int var1);
    }

    public static final class Person {
        private int id;
        private String firstName;
        private String lastName;
        private Timestamp created;
        private Timestamp modified;

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public Timestamp getCreated() {
            return this.created;
        }

        public void setCreated(Timestamp created) {
            this.created = created;
        }

        public Timestamp getModified() {
            return this.modified;
        }

        public void setModified(Timestamp modified) {
            this.modified = modified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.id != person.id) {
                return false;
            }
            if (!this.firstName.equals(person.firstName)) {
                return false;
            }
            return Objects.equals(this.lastName, person.lastName);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + this.firstName.hashCode();
            result = 31 * result + this.lastName.hashCode();
            result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
            result = 31 * result + (this.modified != null ? this.modified.hashCode() : 0);
            return result;
        }
    }

    public static final class PersonRowMapper
    implements RowMapper<Person> {
        public Person map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
            Person person = new Person(resultSet.getString("firstName"), resultSet.getString("lastName"));
            person.setId(resultSet.getInt("id"));
            person.setCreated(resultSet.getTimestamp("created"));
            person.setModified(resultSet.getTimestamp("modified"));
            return person;
        }
    }
}

