/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.locator.UseClasspathSqlLocator;
import org.jdbi.v3.sqlobject.statement.SqlScript;
import org.jdbi.v3.sqlobject.statement.SqlScripts;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestSqlScripts {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testCreateTable() {
        Scriptacular scripts = (Scriptacular)this.h2Extension.getSharedHandle().attach(Scriptacular.class);
        scripts.createTable("cool_table");
        Assertions.assertThat((int[])scripts.doSomeUpdates()).containsExactly(new int[]{3, 2});
        Assertions.assertThat((int[])scripts.externalScript()).containsExactly(new int[]{0, 3, 1});
    }

    private static interface Scriptacular {
        @SqlScript(value="CREATE TABLE <name> (pk int primary key)")
        public void createTable(@Define String var1);

        @SqlScripts(value={@SqlScript(value="INSERT INTO cool_table VALUES (5), (6), (7)"), @SqlScript(value="DELETE FROM cool_table WHERE pk > 5")})
        public int[] doSomeUpdates();

        @UseClasspathSqlLocator
        @SqlScripts(value={@SqlScript, @SqlScript(value="secondScript")})
        public int[] externalScript();
    }
}

