/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class GenericDaoUsageTest {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Before
    public void setUp() {
        Handle handle = this.dbRule.getSharedHandle();
        handle.execute("CREATE TABLE usermodel (id identity primary key, name VARCHAR)", new Object[0]);
        ((UserDao)handle.attach(UserDao.class)).insert(new UserModel(1));
    }

    @Test
    public void testSqlObjectUseGenericDaoInterface() {
        Dao dao = (Dao)this.dbRule.getJdbi().onDemand(UserDao.class);
        dao.getById(1);
    }

    @Test
    public void testSqlObjectUseConcreteDaoInterface() {
        UserDao userDao = (UserDao)this.dbRule.getJdbi().onDemand(UserDao.class);
        UserModel entity = userDao.getById(1);
    }

    @RegisterBeanMapper(value=UserModel.class)
    public static interface UserDao
    extends Dao<UserModel, Integer> {
        @Override
        @SqlQuery(value="SELECT * FROM UserModel WHERE id = :id")
        public UserModel getById(Integer var1);

        @Override
        @SqlUpdate(value="INSERT INTO UserModel (id) VALUES(:id)")
        @GetGeneratedKeys
        public Integer insert(@BindBean UserModel var1);
    }

    public static interface Dao<T extends Model<PK>, PK>
    extends SqlObject {
        public T getById(PK var1);

        public Integer insert(T var1);
    }

    public static class UserModel
    implements Model<Integer> {
        private int id;

        public UserModel() {
        }

        public UserModel(int id) {
            this.id = id;
        }

        @Override
        public Integer getId() {
            return this.id;
        }

        @Override
        public void setId(Integer id) {
            this.id = id;
        }
    }

    public static interface Model<PK> {
        public PK getId();

        public void setId(PK var1);
    }
}

