/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.h2.H2DatabasePlugin;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.statement.BatchChunkSize;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestBatchingSingleValue {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new H2DatabasePlugin());
    private Handle handle;
    private SingleValueBatching b;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
        this.handle.execute("create table batching (id integer, values array)", new Object[0]);
        this.b = (SingleValueBatching)this.handle.attach(SingleValueBatching.class);
    }

    @Test
    public void testSingleValueArray() throws Exception {
        int[] ids = IntStream.range(0, 10).toArray();
        int[] values = IntStream.range(50, 60).toArray();
        this.b.insertValues(ids, values);
        Assertions.assertThat(this.b.select()).containsExactly((Object[])Arrays.stream(ids).mapToObj(id -> new BatchingRow(id, values)).toArray(BatchingRow[]::new));
    }

    public static class BatchingRow {
        final int id;
        final int[] values;

        public BatchingRow(int id, int[] values) {
            this.id = id;
            this.values = values;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BatchingRow) {
                BatchingRow other = (BatchingRow)obj;
                return this.id == other.id && Arrays.equals(this.values, other.values);
            }
            return false;
        }

        public int hashCode() {
            return this.id ^ Arrays.hashCode(this.values);
        }

        public String toString() {
            return String.format("%s %s", this.id, Arrays.toString(this.values));
        }
    }

    @BatchChunkSize(value=4)
    @RegisterConstructorMapper(value=BatchingRow.class)
    public static interface SingleValueBatching {
        @SqlBatch(value="insert into batching (id, values) values (:id, :values)")
        public int[] insertValues(int[] var1, @SingleValue int[] var2);

        @SqlQuery(value="select id, values from batching order by id asc")
        public List<BatchingRow> select();
    }
}

