/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.subpackage.PrivateImplementationFactory;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestBeanBinder {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testInsert() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(new Something(2, "Bean"));
        String name = (String)this.handle.createQuery("select name from something where id = 2").mapTo(String.class).findOnly();
        Assertions.assertThat((String)name).isEqualTo((Object)"Bean");
    }

    @Test
    public void testRead() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        this.handle.execute("insert into something (id, name) values (17, 'Phil')", new Object[0]);
        Something phil = s.findByEqualsOnBothFields(new Something(17, "Phil"));
        Assertions.assertThat((String)phil.getName()).isEqualTo((Object)"Phil");
    }

    @Test
    public void testBindingPrivateTypeUsingPublicInterface() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        Assertions.assertThat((String)s.selectPublicInterfaceValue(PrivateImplementationFactory.create())).isEqualTo((Object)"IShouldBind");
    }

    public static interface PublicInterface {
        public String getValue();
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@BindBean Something var1);

        @SqlQuery(value="select id, name from something where id = :s.id and name = :s.name")
        public Something findByEqualsOnBothFields(@BindBean(value="s") Something var1);

        @SqlQuery(value="select :pi.value")
        public String selectPublicInterfaceValue(@BindBean(value="pi") PublicInterface var1);
    }
}

