/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.ValueType;
import org.jdbi.v3.core.mapper.ValueTypeMapper;
import org.jdbi.v3.core.result.LinkedHashMapRowReducer;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterBeanMappers;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.UseRowReducer;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestBeanMapper {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle h;
    TestDao dao;

    @Before
    public void createTable() throws Exception {
        this.h = this.dbRule.openHandle();
        this.h.createUpdate("create table testBean (valueType varchar(50))").execute();
        this.dao = (TestDao)this.h.attach(TestDao.class);
    }

    @Test
    public void testMapBean() {
        this.h.createUpdate("insert into testBean (valueType) values ('foo')").execute();
        List<TestBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(TestBean::getValueType).containsExactly((Object[])new ValueType[]{ValueType.valueOf((String)"foo")});
    }

    @Test
    public void testMapBeanPrefix() {
        this.h.createUpdate("insert into testBean (valueType) values ('foo')").execute();
        List<TestBean> beans = this.dao.listBeansPrefix();
        Assertions.assertThat(beans).extracting(TestBean::getValueType).containsExactly((Object[])new ValueType[]{ValueType.valueOf((String)"foo")});
    }

    @Test
    public void testFoldWithPrefixedMappers() {
        this.h.execute("create table folders (id identity primary key, name varchar(50))", new Object[0]);
        this.h.execute("create table documents (id identity primary key, folder_id integer, name varchar(50), contents varchar(1000))", new Object[0]);
        Folder folder1 = new Folder(1, "folder1", new Document[0]);
        Folder folder2 = new Folder(2, "folder2", new Document[0]);
        Folder folder3 = new Folder(3, "folder3", new Document[0]);
        Document doc1 = new Document(4, "doc1.txt", "hello");
        Document doc2 = new Document(5, "doc2.txt", "foo");
        Document doc3 = new Document(6, "doc3.txt", "bar");
        DocumentDao dao = (DocumentDao)this.h.attach(DocumentDao.class);
        dao.insertFolders(folder1, folder2, folder3);
        dao.insertDocuments(folder2, doc1);
        dao.insertDocuments(folder3, doc2, doc3);
        Assertions.assertThat(dao.getFolder(1)).contains((Object)new Folder(1, "folder1", new Document[0]));
        Assertions.assertThat(dao.getFolder(2)).contains((Object)new Folder(2, "folder2", doc1));
        Assertions.assertThat(dao.getFolder(3)).contains((Object)new Folder(3, "folder3", doc2, doc3));
        Assertions.assertThat(dao.listFolders()).containsExactly((Object[])new Folder[]{new Folder(1, "folder1", new Document[0]), new Folder(2, "folder2", doc1), new Folder(3, "folder3", doc2, doc3)});
    }

    private static interface DocumentDao
    extends SqlObject {
        @SqlBatch(value="insert into folders (id, name) values (:id, :name)")
        public void insertFolders(Folder ... var1);

        @SqlBatch(value="insert into documents (id, folder_id, name, contents) values (:d.id, :f.id, :d.name, :d.contents)")
        public void insertDocuments(@BindBean(value="f") Folder var1, Document ... var2);

        @SqlQuery(value="select f.id f_id, f.name f_name, d.id d_id, d.name d_name, d.contents d_contents from folders f left join documents d on f.id = d.folder_id where f.id = :folderId")
        @RegisterBeanMappers(value={@RegisterBeanMapper(value=Folder.class, prefix="f"), @RegisterBeanMapper(value=Document.class, prefix="d")})
        @UseRowReducer(value=FolderDocReducer.class)
        public Optional<Folder> getFolder(int var1);

        @SqlQuery(value="select f.id f_id, f.name f_name, d.id d_id, d.name d_name, d.contents d_contents from folders f left join documents d on f.id = d.folder_id order by f.name, d.name")
        @RegisterBeanMappers(value={@RegisterBeanMapper(value=Folder.class, prefix="f"), @RegisterBeanMapper(value=Document.class, prefix="d")})
        @UseRowReducer(value=FolderDocReducer.class)
        public List<Folder> listFolders();

        public static class FolderDocReducer
        implements LinkedHashMapRowReducer<Integer, Folder> {
            public void accumulate(Map<Integer, Folder> map, RowView rv) {
                Folder f = map.computeIfAbsent((Integer)rv.getColumn("f_id", Integer.class), id -> (Folder)rv.getRow(Folder.class));
                if (rv.getColumn("d_id", Integer.class) != null) {
                    f.getDocuments().add((Document)rv.getRow(Document.class));
                }
            }
        }
    }

    public static class Folder {
        private int id;
        private String name;
        private List<Document> documents = new ArrayList<Document>();

        public Folder() {
        }

        public Folder(int id, String name, Document ... documents) {
            this.id = id;
            this.name = name;
            this.documents = Arrays.asList(documents);
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Document> getDocuments() {
            return this.documents;
        }

        public void setDocuments(List<Document> documents) {
            this.documents = documents;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Folder)) {
                return false;
            }
            Folder that = (Folder)obj;
            return this.id == that.id && Objects.equals(this.name, that.name) && Objects.equals(this.documents, that.documents);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.documents);
        }

        public String toString() {
            return "Folder{id=" + this.id + ", name='" + this.name + '\'' + ", documents=" + this.documents + '}';
        }
    }

    public static class Document {
        private int id;
        private String name;
        private String contents;

        public Document() {
        }

        public Document(int id, String name, String contents) {
            this.id = id;
            this.name = name;
            this.contents = contents;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContents() {
            return this.contents;
        }

        public void setContents(String contents) {
            this.contents = contents;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Document)) {
                return false;
            }
            Document that = (Document)obj;
            return this.id == that.id && Objects.equals(this.name, that.name) && Objects.equals(this.contents, that.contents);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.contents);
        }

        public String toString() {
            return "Document{id=" + this.id + ", name='" + this.name + '\'' + ", contents='" + this.contents + '\'' + '}';
        }
    }

    @RegisterColumnMapper(value=ValueTypeMapper.class)
    public static interface TestDao {
        @SqlQuery(value="select * from testBean")
        @RegisterBeanMapper(value=TestBean.class)
        public List<TestBean> listBeans();

        @SqlQuery(value="select valueType as bean_value_type from testBean")
        @RegisterBeanMapper(value=TestBean.class, prefix="bean_")
        public List<TestBean> listBeansPrefix();
    }

    public static class TestBean {
        private ValueType valueType;

        public ValueType getValueType() {
            return this.valueType;
        }

        public void setValueType(ValueType valueType) {
            this.valueType = valueType;
        }
    }
}

