/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestBindAutomaticNames {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
    }

    @Test
    public void testAnnotationNoValue() throws Exception {
        Spiffy spiffy = (Spiffy)this.handle.attach(Spiffy.class);
        Something s = spiffy.findById(7);
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Tim");
    }

    @Test
    public void testNoAnnotation() throws Exception {
        Spiffy spiffy = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        Something s = spiffy.findByIdNoAnnotation(7);
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Tim");
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind int var1);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findByIdNoAnnotation(int var1);
    }
}

