/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Rule;
import org.junit.Test;

public class TestBindExpression {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testExpression() throws Exception {
        DB db = (DB)this.dbRule.getSharedHandle().attach(DB.class);
        db.insert(new Something(1, "syrup"), new Something(2, "whipped cream"));
        Something withSyrup = db.findByBreakfast(new Breakfast());
        Assertions.assertThat((Object)withSyrup).isEqualTo((Object)new Something(1, "syrup"));
    }

    @Test
    public void testJexl() throws Exception {
        JexlEngine engine = new JexlEngine();
        Object topping = engine.createExpression("breakfast.waffle.topping").evaluate((JexlContext)new MapContext((Map)ImmutableMap.of((Object)"breakfast", (Object)new Breakfast())));
        Assertions.assertThat((Object)topping).isEqualTo((Object)"syrup");
    }

    public static class Waffle {
        private final String topping = "syrup";

        public String getTopping() {
            return "syrup";
        }
    }

    public static class Breakfast {
        private final Waffle waffle = new Waffle();

        public Waffle getWaffle() {
            return this.waffle;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlStatementCustomizingAnnotation(value=BindExpressionCustomizerFactory.class)
    public static @interface BindRoot {
        public String value();

        public static class BindExpressionCustomizerFactory
        implements SqlStatementCustomizerFactory {
            public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
                String rootName = ((BindRoot)annotation).value();
                JexlEngine engine = new JexlEngine();
                return (q, root) -> q.bindNamedArgumentFinder((name, context) -> {
                    Expression e = engine.createExpression(name);
                    Object it = e.evaluate((JexlContext)new MapContext((Map)ImmutableMap.of((Object)rootName, (Object)root)));
                    return it == null ? Optional.empty() : Optional.of((position, statement, ctx) -> statement.setObject(position, it));
                });
            }
        }
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface DB {
        @SqlBatch(value="insert into something (id, name) values(:id, :name)")
        public void insert(Something ... var1);

        @SqlQuery(value="select id, name from something where name = :breakfast.waffle.topping limit 1")
        public Something findByBreakfast(@BindRoot(value="breakfast") Breakfast var1);
    }
}

