/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindFields;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestBindFields {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private Dao dao;

    @Before
    public void setUp() {
        this.handle = this.dbRule.getSharedHandle();
        this.dao = (Dao)this.handle.attach(Dao.class);
        this.handle.execute("CREATE TABLE the_table (id IDENTITY PRIMARY KEY, name varchar)", new Object[0]);
    }

    @Test
    public void testBindFields() {
        this.handle.execute("insert into the_table (id, name) values (1, 'Alice')", new Object[0]);
        Assertions.assertThat((String)this.dao.getName(1L)).isEqualTo((Object)"Alice");
        this.dao.update(new TestObject(1, "Alicia"));
        Assertions.assertThat((String)this.dao.getName(1L)).isEqualTo((Object)"Alicia");
    }

    @Test
    public void testBindFieldsPrefix() {
        this.handle.execute("insert into the_table (id, name) values (2, 'Bob')", new Object[0]);
        Assertions.assertThat((String)this.dao.getName(2L)).isEqualTo((Object)"Bob");
        this.dao.updatePrefix(new TestObject(2, "Rob"));
        Assertions.assertThat((String)this.dao.getName(2L)).isEqualTo((Object)"Rob");
    }

    public static interface Dao {
        @SqlUpdate(value="update the_table set name=:name where id=:id")
        public void update(@BindFields TestObject var1);

        @SqlUpdate(value="update the_table set name=:thing.name where id=:thing.id")
        public void updatePrefix(@BindFields(value="thing") TestObject var1);

        @SqlQuery(value="select name from the_table where id = :id")
        public String getName(long var1);
    }

    public class TestObject {
        public final int id;
        public final String name;

        public TestObject(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int id() {
            throw new RuntimeException("Should not be called.");
        }

        public int getId() {
            throw new RuntimeException("Should not be called.");
        }

        public int name() {
            throw new RuntimeException("Should not be called.");
        }

        public int getName() {
            throw new RuntimeException("Should not be called.");
        }
    }
}

