/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestBindLocalDate {
    @Rule
    public H2DatabaseRule rule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private Dao dao;

    @Before
    public void setUp() {
        this.handle = this.rule.getSharedHandle();
        this.dao = (Dao)this.handle.attach(Dao.class);
        this.handle.execute("create table bind_local_date_test ( id int auto_increment primary key, date_column timestamp not null)", new Object[0]);
    }

    @After
    public void tearDown() {
        this.handle.execute("drop table bind_local_date_test", new Object[0]);
    }

    @Test
    public void testBindLocalDate() {
        LocalDate date = LocalDate.of(2001, 2, 1);
        long id = this.dao.insert(date);
        LocalDate inserted = this.dao.findById(id);
        Assertions.assertThat((LocalDate)inserted).isEqualTo((Object)date);
    }

    @Test
    public void testBindTimestamp() {
        LocalDate date = LocalDate.of(2001, 2, 1);
        long id = this.dao.insert(date);
        Timestamp inserted = this.dao.findByIdAsTimestamp(id);
        Assertions.assertThat((Date)inserted).isEqualTo((Object)Timestamp.valueOf(date.atStartOfDay()));
    }

    public static interface Dao {
        @SqlQuery(value="select date_column from bind_local_date_test where id = :id")
        public LocalDate findById(@Bind(value="id") long var1);

        @SqlQuery(value="select date_column from bind_local_date_test where id = :id")
        public Timestamp findByIdAsTimestamp(@Bind(value="id") long var1);

        @GetGeneratedKeys
        @SqlUpdate(value="insert into bind_local_date_test(date_column) values (:date)")
        public long insert(@Bind(value="date") LocalDate var1);
    }
}

