/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindMap;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestBindMap {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Handle handle;
    private Dao dao;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
        this.dao = (Dao)this.handle.attach(Dao.class);
    }

    @Test
    public void testBindMap() throws Exception {
        this.handle.execute("insert into something (id, name) values (1, 'Alice')", new Object[0]);
        this.dao.update(1, Collections.singletonMap("name", "Alicia"));
        Assertions.assertThat((String)this.dao.get(1L).getName()).isEqualTo((Object)"Alicia");
    }

    @Test
    public void testBindMapPrefixed() throws Exception {
        this.handle.execute("insert into something (id, name) values (1, 'Alice')", new Object[0]);
        this.dao.updatePrefix(1, Collections.singletonMap("name", "Alicia"));
        Assertions.assertThat((String)this.dao.get(1L).getName()).isEqualTo((Object)"Alicia");
    }

    @Test
    public void testBindMapKeyInKeysAndMap() throws Exception {
        this.handle.execute("insert into something (id, name) values (2, 'Bob')", new Object[0]);
        this.dao.updateNameKey(2, Collections.singletonMap("name", "Rob"));
        Assertions.assertThat((String)this.dao.get(2L).getName()).isEqualTo((Object)"Rob");
    }

    @Test
    public void testBindMapKeyInKeysNotInMap() throws Exception {
        this.handle.execute("insert into something(id, name) values (2, 'Bob')", new Object[0]);
        this.dao.updateNameKey(2, Collections.emptyMap());
        Assertions.assertThat((String)this.dao.get(2L).getName()).isNull();
    }

    @Test
    public void testBindMapKeyInMapNotInKeys() throws Exception {
        this.handle.execute("insert into something(id, name) values (3, 'Carol')", new Object[0]);
        this.dao.updateNameKey(3, (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"Cheryl", (Object)"integerValue", (Object)3));
        Assertions.assertThat((String)this.dao.get(3L).getName()).isEqualTo((Object)"Cheryl");
        Assertions.assertThat((Integer)this.dao.get(3L).getIntegerValue()).isNull();
    }

    @Test
    public void testBindMapKeyNotInMapOrKeys() throws Exception {
        this.handle.execute("insert into something(id, name) values (3, 'Carol')", new Object[0]);
        this.exception.expect(UnableToExecuteStatementException.class);
        this.dao.update(3, Collections.emptyMap());
    }

    @Test
    public void testBindMapConvertKeysStringKeys() throws Exception {
        this.handle.execute("insert into something(id, name) values (4, 'Dave')", new Object[0]);
        this.dao.updateConvertKeys(4, Collections.singletonMap("name", "David"));
        Assertions.assertThat((String)this.dao.get(4L).getName()).isEqualTo((Object)"David");
    }

    @Test
    public void testBindMapConvertKeysNonStringKeys() throws Exception {
        this.handle.execute("insert into something(id, name) values (4, 'Dave')", new Object[0]);
        this.dao.updateConvertKeys(4, Collections.singletonMap(new MapKey("name"), "David"));
        Assertions.assertThat((String)this.dao.get(4L).getName()).isEqualTo((Object)"David");
    }

    @Test
    public void testBindMapNonStringKeys() throws Exception {
        this.handle.execute("insert into something(id, name) values (5, 'Edward')", new Object[0]);
        this.exception.expect(IllegalArgumentException.class);
        this.dao.update(5, Collections.singletonMap(new MapKey("name"), "Jacob"));
    }

    public static interface Dao {
        @SqlUpdate(value="update something set name=:name where id=:id")
        public void update(@Bind int var1, @BindMap Map<Object, Object> var2);

        @SqlUpdate(value="update something set name=:map.name where id=:id")
        public void updatePrefix(@Bind int var1, @BindMap(value="map") Map<String, Object> var2);

        @SqlUpdate(value="update something set name=:name where id=:id")
        public void updateNameKey(@Bind int var1, @BindMap(keys={"name"}) Map<String, Object> var2);

        @SqlUpdate(value="update something set name=:name where id=:id")
        public void updateConvertKeys(@Bind int var1, @BindMap(convertKeys=true) Map<Object, Object> var2);

        @SqlQuery(value="select * from something where id=:id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something get(long var1);
    }

    public static class MapKey {
        private final String value;

        MapKey(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

