/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindMethods;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestBindMethods {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Before
    public void setUp() {
        Handle h = this.dbRule.getSharedHandle();
        h.execute("CREATE TABLE bind_methods (id IDENTITY PRIMARY KEY, value BIGINT)", new Object[0]);
    }

    @Test
    public void testBindMethodsDirect() {
        PairRowDAO dao = (PairRowDAO)this.dbRule.getJdbi().onDemand(PairRowDAO.class);
        long testValue = 709L;
        int testId = 5;
        DirectDatabaseLongValue dbVal = new DirectDatabaseLongValue(709L);
        PairRow row = new PairRow(5, dbVal);
        Assertions.assertThat((int)dao.insert(row)).isEqualTo(1);
        Assertions.assertThat((Long)dao.getById(5)).isEqualTo(709L);
    }

    @Test
    public void testBindMethodsImplicitOverride() {
        PairRowDAO dao = (PairRowDAO)this.dbRule.getJdbi().onDemand(PairRowDAO.class);
        long testValue = 708L;
        int testId = 6;
        DatabaseLongValueWithOverride dbVal = new DatabaseLongValueWithOverride(708L);
        PairRow row = new PairRow(6, dbVal);
        Assertions.assertThat((int)dao.insert(row)).isEqualTo(1);
        Assertions.assertThat((Long)dao.getById(6)).isEqualTo(708L);
    }

    @Test
    public void testBindMethodsImplicit() {
        PairRowDAO dao = (PairRowDAO)this.dbRule.getJdbi().onDemand(PairRowDAO.class);
        long testValue = 707L;
        int testId = 7;
        DatabaseLongValue dbVal = new DatabaseLongValue(707L);
        PairRow row = new PairRow(7, dbVal);
        Assertions.assertThat((int)dao.insert(row)).isEqualTo(1);
        Assertions.assertThat((Long)dao.getById(7)).isEqualTo(707L);
    }

    @Test
    public void testSanity() {
        String methodName = "getColumnValue";
        List direct = Arrays.stream(DirectDatabaseLongValue.class.getMethods()).filter(m -> m.getParameterCount() == 0 && m.getName().equals("getColumnValue")).collect(Collectors.toList());
        Assertions.assertThat((int)direct.size()).isEqualTo(2);
        Assertions.assertThat(direct.stream().filter(m -> m.isBridge())).hasSize(1);
        List override = Arrays.stream(DatabaseLongValueWithOverride.class.getMethods()).filter(m -> m.getParameterCount() == 0 && m.getName().equals("getColumnValue")).collect(Collectors.toList());
        Assertions.assertThat((int)override.size()).isEqualTo(3);
        Assertions.assertThat(override.stream().filter(m -> m.isBridge())).hasSize(2);
        List implicit = Arrays.stream(DatabaseLongValue.class.getMethods()).filter(m -> m.getParameterCount() == 0 && m.getName().equals("getColumnValue")).collect(Collectors.toList());
        Assertions.assertThat((int)implicit.size()).isEqualTo(2);
        Assertions.assertThat(implicit.stream().filter(m -> m.isBridge())).hasSize(1);
    }

    public static final class BigIntNumberArgumentFactory
    extends AbstractArgumentFactory<Number> {
        public BigIntNumberArgumentFactory() {
            super(-5);
        }

        protected Argument build(Number value, ConfigRegistry config) {
            return new BigIntNumberArgument(value);
        }
    }

    public static final class BigIntNumberArgument
    implements Argument {
        private final Number value;

        public BigIntNumberArgument(Number value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            statement.setLong(position, this.value.longValue());
        }

        public String toString() {
            return Objects.toString(this.value);
        }
    }

    public static final class DirectDatabaseLongValue
    implements DatabaseValue<Long> {
        private final long value;

        DirectDatabaseLongValue(long value) {
            this.value = value;
        }

        @Override
        public Long getColumnValue() {
            return this.value;
        }
    }

    public static final class DatabaseLongValueWithOverride
    extends DatabaseNumberValue<Long> {
        DatabaseLongValueWithOverride(long value) {
            super(value);
        }

        @Override
        public Long getColumnValue() {
            return (Long)super.getColumnValue();
        }
    }

    public static final class DatabaseLongValue
    extends DatabaseNumberValue<Long> {
        DatabaseLongValue(long value) {
            super(value);
        }
    }

    public static class DatabaseNumberValue<T extends Number>
    implements DatabaseValue<T> {
        private final T value;

        DatabaseNumberValue(T value) {
            this.value = value;
        }

        @Override
        public T getColumnValue() {
            return this.value;
        }
    }

    public static final class PairRow {
        private final int id;
        private final DatabaseValue<?> value;

        PairRow(int id, DatabaseValue<?> value) {
            this.id = id;
            this.value = value;
        }

        public int getKey() {
            return this.id;
        }

        public DatabaseValue<?> getValue() {
            return this.value;
        }
    }

    public static interface DatabaseValue<T> {
        public T getColumnValue();
    }

    public static interface PairRowDAO {
        @SqlUpdate(value="INSERT INTO bind_methods (id, value) VALUES(:row.getKey, :row.getValue.getColumnValue)")
        @RegisterArgumentFactory(value=BigIntNumberArgumentFactory.class)
        public int insert(@BindMethods(value="row") PairRow var1);

        @SqlQuery(value="SELECT value FROM bind_methods WHERE id = :id")
        public Long getById(@Bind(value="id") int var1);
    }
}

