/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestBridgeException {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Before
    public void setUp() {
        this.dbRule.getSharedHandle().execute("CREATE TABLE uniq (id INTEGER PRIMARY KEY)", new Object[0]);
    }

    @Test
    public void testBridgeExceptionPassthru() throws Throwable {
        ExceptionalBridge dao = (ExceptionalBridge)this.dbRule.getSharedHandle().attach(ExceptionallyTypedBridge.class);
        Integer arg = 3;
        Assertions.assertThatThrownBy(() -> {
            for (int i = 0; i < 2; ++i) {
                dao.insert(arg);
            }
        }).isInstanceOf(UnableToExecuteStatementException.class);
    }

    public static interface ExceptionallyTypedBridge
    extends ExceptionalBridge<Integer> {
        @Override
        @SqlUpdate(value="INSERT INTO uniq (id) VALUES(:value)")
        public void insert(Integer var1);
    }

    public static interface ExceptionalBridge<T>
    extends SqlObject {
        public void insert(T var1);
    }
}

