/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.SortedSet;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.guava.GuavaCollectors;
import org.jdbi.v3.guava.GuavaPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Rule;
import org.junit.Test;

public class TestCollectorFactory {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new GuavaPlugin());

    @Test
    public void testExists() throws Exception {
        Handle h = this.dbRule.getSharedHandle();
        h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        Optional rs = (Optional)((Query)h.createQuery("select name from something where id = :id").bind("id", 1)).mapTo(String.class).collect(GuavaCollectors.toOptional());
        org.assertj.guava.api.Assertions.assertThat((Optional)rs).contains((Object)"Coda");
    }

    @Test
    public void testDoesNotExist() throws Exception {
        Handle h = this.dbRule.getSharedHandle();
        h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        Optional rs = (Optional)((Query)h.createQuery("select name from something where id = :id").bind("id", 2)).mapTo(String.class).collect(GuavaCollectors.toOptional());
        org.assertj.guava.api.Assertions.assertThat((Optional)rs).isAbsent();
    }

    @Test
    public void testOnList() throws Exception {
        Handle h = this.dbRule.getSharedHandle();
        h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        h.execute("insert into something (id, name) values (2, 'Brian')", new Object[0]);
        ImmutableList rs = (ImmutableList)h.createQuery("select name from something order by id").mapTo(String.class).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)rs).containsExactly((Object[])new String[]{"Coda", "Brian"});
    }

    @Test
    public void testWithSqlObject() throws Exception {
        Dao dao = (Dao)this.dbRule.getJdbi().onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        ImmutableList<String> rs = dao.findAll();
        Assertions.assertThat(rs).containsExactly((Object[])new String[]{"Coda", "Brian"});
    }

    @Test
    public void testWithSqlObjectSingleValue() throws Exception {
        Dao dao = (Dao)this.dbRule.getJdbi().onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        Object rs = dao.findNameById(1);
        org.assertj.guava.api.Assertions.assertThat(rs).contains((Object)"Coda");
        rs = dao.smartFindNameById(1);
        org.assertj.guava.api.Assertions.assertThat(rs).contains((Object)"Coda");
        rs = dao.inheritedGenericFindNameById(1);
        org.assertj.guava.api.Assertions.assertThat(rs).contains((Object)"Coda");
    }

    @Test
    public void testWithSqlObjectSetReturnValue() throws Exception {
        Dao dao = (Dao)this.dbRule.getJdbi().onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        SortedSet<String> rs = dao.findAllAsSet();
        Assertions.assertThat(rs).containsExactly((Object[])new String[]{"Brian", "Coda"});
    }

    public static interface Base<T> {
        @SqlQuery(value="select name from something where id = :id")
        public Optional<T> inheritedGenericFindNameById(@Bind(value="id") int var1);
    }

    public static interface Dao
    extends Base<String> {
        @SqlQuery(value="select name from something order by id")
        public ImmutableList<String> findAll();

        @SqlQuery(value="select name from something order by id")
        public SortedSet<String> findAllAsSet();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public Optional<String> findNameById(@Bind(value="id") int var1);

        @SqlQuery(value="select name from something where id = :id")
        public Optional<String> smartFindNameById(@Bind(value="id") int var1);
    }
}

