/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.net.URI;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.ValueType;
import org.jdbi.v3.core.mapper.ValueTypeMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapperFactory;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestColumnMappers {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle h;
    SomeBeanDao dao;

    @Before
    public void createTable() throws Exception {
        this.h = this.dbRule.openHandle();
        this.h.createUpdate("create table someBean ( primitiveInt integer, wrapperLong bigint,  primitiveChar varchar(1), wrappedChar varchar(1),  string varchar(50), valueType varchar(50),  uri varchar(50) )").execute();
        this.dao = (SomeBeanDao)this.h.attach(SomeBeanDao.class);
    }

    @After
    public void dropTable() {
        this.h.createUpdate("drop table someBean").execute();
    }

    @Test
    public void testMapPrimitiveInt() throws Exception {
        this.h.createUpdate("insert into someBean (primitiveInt) values (15)").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getPrimitiveInt).containsExactly((Object[])new Integer[]{15});
    }

    @Test
    public void testMapPrimitiveIntFromNull() throws Exception {
        this.h.createUpdate("insert into someBean (primitiveInt) values (null)").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getPrimitiveInt).containsExactly((Object[])new Integer[]{0});
    }

    @Test
    public void testMapPrimitiveChar() throws Exception {
        this.h.createUpdate("insert into someBean (primitiveChar) values ('c')").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getPrimitiveChar).containsExactly((Object[])new Character[]{Character.valueOf('c')});
    }

    @Test
    public void testMapPrimitiveCharFromEmpty() throws Exception {
        this.h.createUpdate("insert into someBean (primitiveChar) values ('')").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getPrimitiveChar).containsExactly((Object[])new Character[]{Character.valueOf('\u0000')});
    }

    @Test
    public void testMapPrimitiveCharFromNull() throws Exception {
        this.h.createUpdate("insert into someBean (primitiveChar) values (null)").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getPrimitiveChar).containsExactly((Object[])new Character[]{Character.valueOf('\u0000')});
    }

    @Test
    public void testMapWrappedChar() throws Exception {
        this.h.createUpdate("insert into someBean (wrappedChar) values ('c')").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getWrappedChar).containsExactly((Object[])new Character[]{Character.valueOf('c')});
    }

    @Test
    public void testMapWrappedCharFromEmpty() throws Exception {
        this.h.createUpdate("insert into someBean (wrappedChar) values ('')").execute();
        List<SomeBean> beans = this.dao.listBeans();
        ((AbstractListAssert)Assertions.assertThat(beans).extracting(SomeBean::getWrappedChar).hasSize(1)).containsNull();
    }

    @Test
    public void testMapWrappedCharFromNull() throws Exception {
        this.h.createUpdate("insert into someBean (wrappedChar) values (null)").execute();
        List<SomeBean> beans = this.dao.listBeans();
        ((AbstractListAssert)Assertions.assertThat(beans).extracting(SomeBean::getWrappedChar).hasSize(1)).containsNull();
    }

    @Test
    public void testMapWrapper() throws Exception {
        this.h.createUpdate("insert into someBean (wrapperLong) values (20)").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getWrapperLong).containsExactly((Object[])new Long[]{20L});
    }

    @Test
    public void testMapWrapperFromNull() throws Exception {
        this.h.createUpdate("insert into someBean (wrapperLong) values (null)").execute();
        List<SomeBean> beans = this.dao.listBeans();
        ((AbstractListAssert)Assertions.assertThat(beans).extracting(SomeBean::getWrapperLong).hasSize(1)).containsNull();
    }

    @Test
    public void testMapString() throws Exception {
        this.h.createUpdate("insert into someBean (string) values ('foo')").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getString).containsExactly((Object[])new String[]{"foo"});
    }

    @Test
    public void testMapStringFromNull() throws Exception {
        this.h.createUpdate("insert into someBean (string) values (null)").execute();
        List<SomeBean> beans = this.dao.listBeans();
        ((AbstractListAssert)Assertions.assertThat(beans).extracting(SomeBean::getString).hasSize(1)).containsNull();
    }

    @Test
    public void testMapValueType() throws Exception {
        this.h.createUpdate("insert into someBean (valueType) values ('foo')").execute();
        List<SomeBean> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(SomeBean::getValueType).containsExactly((Object[])new ValueType[]{ValueType.valueOf((String)"foo")});
    }

    @Test
    public void testMapValueTypeFromNull() throws Exception {
        this.h.createUpdate("insert into someBean (valueType) values (null)").execute();
        List<SomeBean> beans = this.dao.listBeans();
        ((AbstractListAssert)Assertions.assertThat(beans).extracting(SomeBean::getValueType).hasSize(1)).containsNull();
    }

    @Test
    public void testMapValueTypeFromColumnMapperFactory() throws Exception {
        this.h.createUpdate("insert into someBean (valueType) values ('foo')").execute();
        List<SomeBean> beans = this.dao.listBeansFactoryMapped();
        Assertions.assertThat(beans).extracting(SomeBean::getValueType).containsExactly((Object[])new ValueType[]{ValueType.valueOf((String)"foo")});
    }

    @Test
    public void testMapToValueTypeFromColumnMapper() throws Exception {
        this.h.createUpdate("insert into someBean (valueType) values ('foo')").execute();
        List<ValueType> list = this.dao.listValueTypes();
        Assertions.assertThat(list).containsExactly((Object[])new ValueType[]{ValueType.valueOf((String)"foo")});
    }

    @Test
    public void testMapToValueTypeFromColumnMapperFactory() throws Exception {
        this.h.createUpdate("insert into someBean (valueType) values ('foo')").execute();
        List<ValueType> list = this.dao.listValueTypesFactoryMapped();
        Assertions.assertThat(list).containsExactly((Object[])new ValueType[]{ValueType.valueOf((String)"foo")});
    }

    @Test
    public void testMapUri() throws Exception {
        this.h.createUpdate("insert into someBean (uri) values ('urn:foo')").execute();
        List<SomeBean> list = this.dao.listBeans();
        Assertions.assertThat(list).extracting(SomeBean::getUri).containsExactly((Object[])new URI[]{new URI("urn:foo")});
    }

    @Test
    public void testMapUriFromNull() throws Exception {
        this.h.createUpdate("insert into someBean (uri) values (null)").execute();
        List<SomeBean> list = this.dao.listBeans();
        ((AbstractListAssert)Assertions.assertThat(list).extracting(SomeBean::getUri).hasSize(1)).containsNull();
    }

    public static interface SomeBeanDao {
        @RegisterBeanMapper(value=SomeBean.class)
        @RegisterColumnMapper(value=ValueTypeMapper.class)
        @SqlQuery(value="select * from someBean")
        public List<SomeBean> listBeans();

        @RegisterBeanMapper(value=SomeBean.class)
        @RegisterColumnMapperFactory(value=ValueTypeMapper.Factory.class)
        @SqlQuery(value="select * from someBean")
        public List<SomeBean> listBeansFactoryMapped();

        @RegisterColumnMapper(value=ValueTypeMapper.class)
        @SqlQuery(value="select valueType from someBean")
        public List<ValueType> listValueTypes();

        @RegisterColumnMapperFactory(value=ValueTypeMapper.Factory.class)
        @SqlQuery(value="select valueType from someBean")
        public List<ValueType> listValueTypesFactoryMapped();
    }

    public static class SomeBean {
        int primitiveInt;
        Long wrapperLong;
        String string;
        ValueType valueType;
        URI uri;
        char primitiveChar;
        Character wrappedChar;

        public int getPrimitiveInt() {
            return this.primitiveInt;
        }

        public void setPrimitiveInt(int primitiveInt) {
            this.primitiveInt = primitiveInt;
        }

        public char getPrimitiveChar() {
            return this.primitiveChar;
        }

        public void setPrimitiveChar(char primitiveChar) {
            this.primitiveChar = primitiveChar;
        }

        public Character getWrappedChar() {
            return this.wrappedChar;
        }

        public void setWrappedChar(Character wrappedChar) {
            this.wrappedChar = wrappedChar;
        }

        public Long getWrapperLong() {
            return this.wrapperLong;
        }

        public void setWrapperLong(Long wrapperLong) {
            this.wrapperLong = wrapperLong;
        }

        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public ValueType getValueType() {
            return this.valueType;
        }

        public void setValueType(ValueType valueType) {
            this.valueType = valueType;
        }
    }
}

