/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.testing.JdbiRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestConcurrentUpdatingQuery {
    @Rule
    public JdbiRule dbRule = JdbiRule.h2();
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getHandle();
    }

    @Test
    public void testConcurrentUpdateableResultSet() throws Exception {
        this.handle.execute("create table something (id identity primary key, name varchar(50))", new Object[0]);
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        ((Query)this.handle.createQuery("select id, name from something where id = :id").bind("id", 7)).concurrentUpdatable().map((r, ctx) -> {
            r.updateString("name", "Tom");
            r.updateRow();
            return null;
        }).list();
        String name = (String)((Query)this.handle.createQuery("select name from something where id = :id").bind("id", 7)).mapTo(String.class).findOnly();
        Assertions.assertThat((String)name).isEqualTo((Object)"Tom");
    }
}

