/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Rule;
import org.junit.Test;

public class TestConsumer {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testReturnStream() throws Exception {
        Something one = new Something(3, "foo");
        Something two = new Something(4, "bar");
        Something thr = new Something(5, "baz");
        Spiffy dao = (Spiffy)this.dbRule.getJdbi().open().attach(Spiffy.class);
        dao.insert(one);
        dao.insert(thr);
        dao.insert(two);
        ArrayList results = new ArrayList();
        dao.forEach(results::add);
        Assertions.assertThat(results).containsExactly((Object[])new Something[]{thr, two, one});
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something order by id desc")
        @UseRowMapper(value=SomethingMapper.class)
        public void forEach(Consumer<Something> var1);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);
    }
}

