/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.CreateSqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestCreateSqlObjectAnnotation {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.dbRule.getJdbi().registerRowMapper((RowMapper)new SomethingMapper());
        this.handle = this.dbRule.getSharedHandle();
        this.handle.registerRowMapper((RowMapper)new SomethingMapper());
    }

    @Test
    public void testSimpleCreate() throws Exception {
        Foo foo = (Foo)this.handle.attach(Foo.class);
        foo.insert(1, "Stephane");
        Something s = foo.createBar().findById(1);
        Assertions.assertThat((Object)s).isEqualTo((Object)new Something(1, "Stephane"));
    }

    @Test
    public void testInsertAndFind() throws Exception {
        Foo foo = (Foo)this.handle.attach(Foo.class);
        Something s = foo.insertAndFind(1, "Stephane");
        Assertions.assertThat((Object)s).isEqualTo((Object)new Something(1, "Stephane"));
    }

    @Test
    public void testTransactionPropagates() throws Exception {
        Foo foo = (Foo)this.dbRule.getJdbi().open().attach(Foo.class);
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> foo.insertAndFail(1, "Jeff"));
        Something n = foo.createBar().findById(1);
        Assertions.assertThat((Object)n).isNull();
    }

    @Test
    public void testMeaningfulExceptionWhenWrongReturnTypeOfSqlUpdate() throws Exception {
        this.expectedException.expect(UnableToCreateSqlObjectException.class);
        this.expectedException.expectMessage("BogusSqlUpdateDao.getNames method is annotated with @SqlUpdate so should return void, boolean, or Number but is returning: java.util.List<java.lang.String>");
        this.dbRule.getJdbi().open().attach(BogusSqlUpdateDao.class);
    }

    @Test
    public void testMeaningfulExceptionWhenWrongReturnTypeOfSqlBatch() throws Exception {
        this.expectedException.expect(UnableToCreateSqlObjectException.class);
        this.expectedException.expectMessage("BogusSqlBatchDao.getNames method is annotated with @SqlBatch so should return void, int[], or boolean[] but is returning: int");
        this.dbRule.getJdbi().open().attach(BogusSqlBatchDao.class);
    }

    public static interface BogusSqlBatchDao {
        @SqlBatch(value="insert into table (a) values (:a)")
        public int getNames(@Bind(value="a") String var1);
    }

    public static interface BogusSqlUpdateDao {
        @SqlUpdate(value="select name from something")
        public List<String> getNames();
    }

    public static interface Bar {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        default public Something explode() {
            throw new RuntimeException();
        }
    }

    public static interface Foo {
        @CreateSqlObject
        public Bar createBar();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @Transaction
        default public Something insertAndFind(int id, String name) {
            this.insert(id, name);
            return this.createBar().findById(id);
        }

        @Transaction
        default public Something insertAndFail(int id, String name) {
            this.insert(id, name);
            return this.createBar().explode();
        }
    }
}

