/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindSomething;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Rule;
import org.junit.Test;

public class TestCustomBinder {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testFoo() throws Exception {
        this.dbRule.getSharedHandle().execute("insert into something (id, name) values (2, 'Martin')", new Object[0]);
        this.dbRule.getJdbi().useExtension(Spiffy.class, spiffy -> {
            Something s = spiffy.findSame(new Something(2, "Unknown"));
            Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Martin");
        });
    }

    @Test
    public void testCustomBindingAnnotation() throws Exception {
        Spiffy s = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        s.insert(new Something(2, "Keith"));
        Assertions.assertThat((String)s.findNameById(2)).isEqualTo((Object)"Keith");
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :it.id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something findSame(@BindSomething(value="it") Something var1);

        @SqlUpdate(value="insert into something (id, name) values (:s.id, :s.name)")
        public int insert(@BindSomething(value="s") Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }
}

