/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindSomething;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Rule;
import org.junit.Test;

public class TestDefaultMethods {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testDefaultMethod() throws Exception {
        Spiffy dao = (Spiffy)this.dbRule.getJdbi().onDemand(Spiffy.class);
        Something test = dao.insertAndReturn(3, "test");
        Assertions.assertThat((Object)test).isEqualTo((Object)new Something(3, "test"));
    }

    @Test
    public void testOverride() throws Exception {
        SpiffyOverride dao = (SpiffyOverride)this.dbRule.getJdbi().onDemand(SpiffyOverride.class);
        Assertions.assertThat((Object)dao.insertAndReturn(123, "fake")).isNull();
    }

    @Test
    public void testOverrideWithDefault() throws Exception {
        SpiffyOverrideWithDefault dao = (SpiffyOverrideWithDefault)this.dbRule.getJdbi().onDemand(SpiffyOverrideWithDefault.class);
        Assertions.assertThat((int)dao.insertAndReturn(123, "fake").getId()).isEqualTo(-6);
    }

    @Test
    public void testHandleHasExtensionMethodSet() throws Exception {
        this.dbRule.getJdbi().useExtension(StatementContextExtensionMethodDao.class, dao -> dao.check());
    }

    private static interface StatementContextExtensionMethodDao
    extends SqlObject {
        default public void check() throws Exception {
            Class<StatementContextExtensionMethodDao> extensionMethodDaoClass = StatementContextExtensionMethodDao.class;
            Method checkMethod = extensionMethodDaoClass.getMethod("check", new Class[0]);
            ExtensionMethod extensionMethod = this.getHandle().getExtensionMethod();
            Assertions.assertThat((Class)extensionMethod.getType()).isEqualTo(extensionMethodDaoClass);
            Assertions.assertThat((Object)extensionMethod.getMethod()).isEqualTo((Object)checkMethod);
            extensionMethod = this.getHandle().createQuery("select * from something").getContext().getExtensionMethod();
            Assertions.assertThat((Class)extensionMethod.getType()).isEqualTo(extensionMethodDaoClass);
            Assertions.assertThat((Object)extensionMethod.getMethod()).isEqualTo((Object)checkMethod);
        }
    }

    public static interface SpiffyOverrideWithDefault
    extends SpiffyOverride {
        @Override
        default public Something insertAndReturn(int id, String name) {
            return new Something(-6, "what");
        }
    }

    public static interface SpiffyOverride
    extends Spiffy {
        @Override
        @UseRowMapper(value=SomethingMapper.class)
        @SqlQuery(value="select id, name from something where id = :id")
        public Something insertAndReturn(@Bind int var1, @Bind String var2);
    }

    private static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") int var1);

        @SqlUpdate(value="insert into something (id, name) values (:it.id, :it.name)")
        public void insert(@BindSomething(value="it") Something var1);

        default public Something insertAndReturn(int id, String name) {
            this.insert(new Something(id, name));
            return this.byId(id);
        }
    }
}

