/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestDefineParameter {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testDefineParameter() throws Exception {
        this.handle.execute("create table stuff (id identity primary key, name varchar(50))", new Object[0]);
        this.handle.execute("create table junk (id identity primary key, name varchar(50))", new Object[0]);
        HoneyBadger badass = (HoneyBadger)this.handle.attach(HoneyBadger.class);
        Something ted = new Something(1, "Ted");
        Something fred = new Something(2, "Fred");
        badass.insert("stuff", ted);
        badass.insert("junk", fred);
        Assertions.assertThat((Object)badass.findById("stuff", 1L)).isEqualTo((Object)ted);
        Assertions.assertThat((Object)badass.findById("junk", 1L)).isNull();
        Assertions.assertThat((Object)badass.findById("stuff", 2L)).isNull();
        Assertions.assertThat((Object)badass.findById("junk", 2L)).isEqualTo((Object)fred);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface HoneyBadger {
        @SqlUpdate(value="insert into <table> (id, name) values (:id, :name)")
        public void insert(@Define(value="table") String var1, @BindBean Something var2);

        @SqlQuery(value="select id, name from <table> where id = :id")
        public Something findById(@Define String var1, @Bind(value="id") long var2);
    }
}

