/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.BatchChunkSize;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Rule;
import org.junit.Test;

public class TestDocumentation {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testFiveMinuteFluentApi() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            h.execute("insert into something (id, name) values (?, ?)", new Object[]{1, "Brian"});
            String name = (String)((Query)h.createQuery("select name from something where id = :id").bind("id", 1)).mapTo(String.class).findOnly();
            Assertions.assertThat((String)name).isEqualTo((Object)"Brian");
        }
    }

    @Test
    public void testFiveMinuteSqlObjectExample() throws Exception {
        this.dbRule.getJdbi().useExtension(MyDAO.class, dao -> {
            dao.insert(2, "Aaron");
            String name = dao.findNameById(2);
            Assertions.assertThat((String)name).isEqualTo((Object)"Aaron");
        });
    }

    @Test
    public void testObtainHandleViaOpen() throws Exception {
        Assertions.assertThatCode(() -> {
            Handle h = this.dbRule.getJdbi().open();
            Throwable throwable = null;
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    h.close();
                }
            }
        }).doesNotThrowAnyException();
    }

    @Test
    public void testObtainHandleInCallback() throws Exception {
        Jdbi db = Jdbi.create((String)("jdbc:h2:mem:" + UUID.randomUUID()));
        db.useHandle(handle -> handle.execute("create table silly (id int)", new Object[0]));
    }

    @Test
    public void testExecuteSomeStatements() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            h.execute("insert into something (id, name) values (?, ?)", new Object[]{3, "Patrick"});
            List rs = h.select("select id, name from something", new Object[0]).mapToMap().list();
            Assertions.assertThat((List)rs).containsExactlyElementsOf((Iterable)ImmutableList.of((Object)ImmutableMap.of((Object)"id", (Object)3L, (Object)"name", (Object)"Patrick")));
        }
    }

    @Test
    public void testFluentUpdate() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            ((org.jdbi.v3.core.statement.Update)((org.jdbi.v3.core.statement.Update)h.createUpdate("insert into something(id, name) values (:id, :name)").bind("id", 4)).bind("name", "Martin")).execute();
        }
    }

    @Test
    public void testMappingExampleChainedIterator2() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            h.execute("insert into something (id, name) values (1, 'Brian')", new Object[0]);
            h.execute("insert into something (id, name) values (2, 'Keith')", new Object[0]);
            ResultIterator rs = h.createQuery("select name from something order by id").mapTo(String.class).iterator();
            Assertions.assertThat((String)((String)rs.next())).isEqualTo((Object)"Brian");
            Assertions.assertThat((String)((String)rs.next())).isEqualTo((Object)"Keith");
            Assertions.assertThat((boolean)rs.hasNext()).isFalse();
        }
    }

    @Test
    public void testMappingExampleChainedIterator3() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            h.execute("insert into something (id, name) values (1, 'Brian')", new Object[0]);
            h.execute("insert into something (id, name) values (2, 'Keith')", new Object[0]);
            ResultIterable names = h.createQuery("select name from something order by id").mapTo(String.class);
            Assertions.assertThat((Iterator)names.iterator()).containsExactly((Object[])new String[]{"Brian", "Keith"});
        }
    }

    @Test
    public void testAttachToObject() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            MyDAO dao = (MyDAO)h.attach(MyDAO.class);
            dao.insert(1, "test");
        }
    }

    @Test
    public void testOnDemandDao() throws Exception {
        MyDAO dao = (MyDAO)this.dbRule.getJdbi().onDemand(MyDAO.class);
        dao.insert(2, "test");
    }

    @Test
    public void testSomeQueriesWorkCorrectly() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            ((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)h.prepareBatch("insert into something (id, name) values (:id, :name)").bind("id", 1)).bind("name", "Brian")).add().bind("id", 2)).bind("name", "Robert")).add().bind("id", 3)).bind("name", "Patrick")).add().bind("id", 4)).bind("name", "Maniax")).add().execute();
            SomeQueries sq = (SomeQueries)h.attach(SomeQueries.class);
            Assertions.assertThat((String)sq.findName(2)).isEqualTo((Object)"Robert");
            Assertions.assertThat(sq.findNamesBetween(1, 4)).containsExactly((Object[])new String[]{"Robert", "Patrick"});
            Iterator<String> names = sq.findAllNames();
            Assertions.assertThat(names).containsExactly((Object[])new String[]{"Brian", "Robert", "Patrick", "Maniax"});
        }
    }

    @Test
    public void testAnotherCoupleInterfaces() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            ((BatchInserter)h.attach(BatchInserter.class)).insert(new Something(1, "Brian"), new Something(3, "Patrick"), new Something(2, "Robert"));
            AnotherQuery aq = (AnotherQuery)h.attach(AnotherQuery.class);
            YetAnotherQuery yaq = (YetAnotherQuery)h.attach(YetAnotherQuery.class);
            Assertions.assertThat((Object)yaq.findById(3)).isEqualTo((Object)new Something(3, "Patrick"));
            Assertions.assertThat((Object)aq.findById(2)).isEqualTo((Object)new Something(2, "Robert"));
        }
    }

    @Test
    public void testFoo() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            ((BatchInserter)h.attach(BatchInserter.class)).insert(new Something(1, "Brian"), new Something(3, "Patrick"), new Something(2, "Robert"));
            QueryReturningResultIterable qrri = (QueryReturningResultIterable)h.attach(QueryReturningResultIterable.class);
            ResultIterable<String> iterable = qrri.findById(1);
            Assertions.assertThat((String)((String)iterable.findOnly())).isEqualTo((Object)"Brian");
        }
    }

    @Test
    public void testUpdateAPI() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            Update u = (Update)h.attach(Update.class);
            u.insert(17, "David");
            u.update(new Something(17, "David P."));
            String name = (String)h.createQuery("select name from something where id = 17").mapTo(String.class).findOnly();
            Assertions.assertThat((String)name).isEqualTo((Object)"David P.");
        }
    }

    @Test
    public void testBatchExample() throws Exception {
        try (Handle h = this.dbRule.openHandle();){
            BatchExample b = (BatchExample)h.attach(BatchExample.class);
            List<Integer> ids = Arrays.asList(1, 2, 3, 4, 5);
            Iterator<String> firstNames = Arrays.asList("Tip", "Jane", "Brian", "Keith", "Eric").iterator();
            b.insertFamily(ids, firstNames, "McCallister");
            Assertions.assertThat((String)b.findNameById(1)).isEqualTo((Object)"Tip McCallister");
            Assertions.assertThat((String)b.findNameById(2)).isEqualTo((Object)"Jane McCallister");
            Assertions.assertThat((String)b.findNameById(3)).isEqualTo((Object)"Brian McCallister");
            Assertions.assertThat((String)b.findNameById(4)).isEqualTo((Object)"Keith McCallister");
            Assertions.assertThat((String)b.findNameById(5)).isEqualTo((Object)"Eric McCallister");
        }
    }

    public static interface BindBeanExample {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlUpdate(value="update something set name = :s.name where id = :s.id")
        public void update(@BindBean(value="s") Something var1);
    }

    public static interface BindExamples {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlUpdate(value="delete from something where name = :it")
        public void deleteByName(@Bind String var1);
    }

    public static interface ChunkedBatchExample {
        @SqlBatch(value="insert into something (id, name) values (:id, :first || ' ' || :last)")
        @BatchChunkSize(value=2)
        public void insertFamily(@Bind(value="id") List<Integer> var1, @Bind(value="first") Iterator<String> var2, @Bind(value="last") String var3);

        @SqlUpdate(value="create table something(id int primary key, name varchar(32))")
        public void createSomethingTable();

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }

    public static interface BatchExample {
        @SqlBatch(value="insert into something (id, name) values (:id, :first || ' ' || :last)")
        public void insertFamily(@Bind(value="id") List<Integer> var1, @Bind(value="first") Iterator<String> var2, @Bind(value="last") String var3);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }

    public static interface Update {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlUpdate(value="update something set name = :name where id = :id")
        public int update(@BindBean Something var1);
    }

    public static interface QueryReturningResultIterable {
        @SqlQuery(value="select name from something where id = :id")
        public ResultIterable<String> findById(@Bind(value="id") int var1);
    }

    public static interface BatchInserter {
        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public void insert(Something ... var1);
    }

    public static interface YetAnotherQuery {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something findById(@Bind(value="id") int var1);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface AnotherQuery {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);
    }

    public static interface SomeQueries {
        @SqlQuery(value="select name from something where id = :id")
        public String findName(@Bind(value="id") int var1);

        @SqlQuery(value="select name from something where id > :from and id < :to order by id")
        public List<String> findNamesBetween(@Bind(value="from") int var1, @Bind(value="to") int var2);

        @SqlQuery(value="select name from something order by id")
        public Iterator<String> findAllNames();
    }

    public static interface MyDAO {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }
}

