/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.JdbiRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestEnumMapping {
    @Rule
    public JdbiRule dbRule = JdbiRule.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Before
    public void create() {
        this.dbRule.getHandle().execute("create table something (id identity primary key, name varchar(50), integerValue integer, intValue integer)", new Object[0]);
    }

    @Test
    public void testEnums() throws Exception {
        Spiffy spiffy = (Spiffy)this.dbRule.attach(Spiffy.class);
        int bobId = spiffy.addCoolName(CoolName.BOB);
        int joeId = spiffy.addCoolName(CoolName.JOE);
        Assertions.assertThat((Comparable)((Object)spiffy.findById(bobId))).isSameAs((Object)CoolName.BOB);
        Assertions.assertThat((Comparable)((Object)spiffy.findById(joeId))).isSameAs((Object)CoolName.JOE);
    }

    public static enum CoolName {
        BOB,
        FRANK,
        JOE;

    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy {
        @SqlUpdate(value="insert into something(name) values(:name)")
        @GetGeneratedKeys
        public int addCoolName(@Bind(value="name") CoolName var1);

        @SqlQuery(value="select name from something where id = :id")
        public CoolName findById(@Bind(value="id") int var1);
    }
}

