/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.rule.PgDatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Rule;
import org.junit.Test;

public class TestGetGeneratedKeysPostgres {
    @Rule
    public PgDatabaseRule dbRule = new PgDatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testFoo() throws Exception {
        this.dbRule.getJdbi().useExtension(DAO.class, dao -> {
            dao.createSequence();
            dao.createTable();
            long brianId = dao.insert("Brian");
            long keithId = dao.insert("Keith");
            Assertions.assertThat((String)dao.findNameById(brianId)).isEqualTo((Object)"Brian");
            Assertions.assertThat((String)dao.findNameById(keithId)).isEqualTo((Object)"Keith");
        });
    }

    @Test
    public void testBatch() throws Exception {
        this.dbRule.getJdbi().useExtension(DAO.class, dao -> {
            dao.createSequence();
            dao.createTable();
            int[] ids = dao.insert(Arrays.asList("Burt", "Macklin"));
            Assertions.assertThat((String)dao.findNameById(ids[0])).isEqualTo((Object)"Burt");
            Assertions.assertThat((String)dao.findNameById(ids[1])).isEqualTo((Object)"Macklin");
        });
    }

    @Test
    public void testUseRowMapperUpdate() throws Exception {
        this.dbRule.getJdbi().useExtension(UseRowMapperDao.class, dao -> {
            dao.createTable();
            IdCreateTime result = dao.insert("foo");
            Assertions.assertThat((long)result.id).isEqualTo(1L);
            Assertions.assertThat((OffsetDateTime)result.createdOn).isNotNull();
        });
    }

    @Test
    public void testUseRowMapperBatch() throws Exception {
        this.dbRule.getJdbi().useExtension(UseRowMapperDao.class, dao -> {
            dao.createTable();
            List<IdCreateTime> results = dao.insertBatch("foo", "bar");
            Assertions.assertThat(results).extracting(ic -> ic.id).containsExactly((Object[])new Long[]{1L, 2L});
            ((AbstractListAssert)Assertions.assertThat(results).extracting(ic -> ic.createdOn).hasSize(2)).doesNotContainNull();
        });
    }

    @Test
    public void testRegisterRowMapperUpdate() throws Exception {
        this.dbRule.getJdbi().useExtension(RegisterRowMapperDao.class, dao -> {
            dao.createTable();
            IdCreateTime result = dao.insert("foo");
            Assertions.assertThat((long)result.id).isEqualTo(1L);
            Assertions.assertThat((OffsetDateTime)result.createdOn).isNotNull();
        });
    }

    @Test
    public void testRegisterRowMapperBatch() throws Exception {
        this.dbRule.getJdbi().useExtension(RegisterRowMapperDao.class, dao -> {
            dao.createTable();
            List<IdCreateTime> results = dao.insertBatch("foo", "bar");
            Assertions.assertThat(results).extracting(ic -> ic.id).containsExactly((Object[])new Long[]{1L, 2L});
            ((AbstractListAssert)Assertions.assertThat(results).extracting(ic -> ic.createdOn).hasSize(2)).doesNotContainNull();
        });
    }

    public static class IdCreateTime {
        final long id;
        final OffsetDateTime createdOn;

        public IdCreateTime(long id, OffsetDateTime createdOn) {
            this.id = id;
            this.createdOn = createdOn;
        }
    }

    public static class IdCreateTimeMapper
    implements RowMapper<IdCreateTime> {
        public IdCreateTime map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new IdCreateTime(rs.getLong("id"), rs.getTimestamp("created_on").toInstant().atOffset(ZoneOffset.UTC));
        }
    }

    public static interface RegisterRowMapperDao {
        @SqlUpdate(value="create table something (id serial, name varchar(50), created_on timestamp default now())")
        public void createTable();

        @SqlUpdate(value="insert into something(name) values (:name)")
        @GetGeneratedKeys(value={"id", "created_on"})
        @RegisterRowMapper(value=IdCreateTimeMapper.class)
        public IdCreateTime insert(String var1);

        @SqlBatch(value="insert into something(name) values (:name)")
        @GetGeneratedKeys(value={"id", "created_on"})
        @RegisterRowMapper(value=IdCreateTimeMapper.class)
        public List<IdCreateTime> insertBatch(String ... var1);
    }

    public static interface UseRowMapperDao {
        @SqlUpdate(value="create table something (id serial, name varchar(50), created_on timestamp default now())")
        public void createTable();

        @SqlUpdate(value="insert into something(name) values (:name)")
        @GetGeneratedKeys(value={"id", "created_on"})
        @UseRowMapper(value=IdCreateTimeMapper.class)
        public IdCreateTime insert(String var1);

        @SqlBatch(value="insert into something(name) values (:name)")
        @GetGeneratedKeys(value={"id", "created_on"})
        @UseRowMapper(value=IdCreateTimeMapper.class)
        public List<IdCreateTime> insertBatch(String ... var1);
    }

    public static interface DAO {
        @SqlUpdate(value="create sequence id_sequence INCREMENT 1 START WITH 100")
        public void createSequence();

        @SqlUpdate(value="create table if not exists something (name text, id int DEFAULT nextval('id_sequence'), CONSTRAINT something_id PRIMARY KEY (id))")
        public void createTable();

        @SqlUpdate(value="insert into something (name, id) values (:name, nextval('id_sequence'))")
        @GetGeneratedKeys(value={"id"})
        public long insert(@Bind(value="name") String var1);

        @SqlBatch(value="insert into something (name) values (:name)")
        @GetGeneratedKeys(value={"id"})
        public int[] insert(@Bind(value="name") List<String> var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind long var1);
    }
}

