/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.assertj.guava.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.guava.GuavaPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestGuavaCollectors {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new GuavaPlugin());
    Handle h;

    @Before
    public void setUp() {
        this.h = this.dbRule.getSharedHandle();
        this.h.execute("create table users (id int, name varchar)", new Object[0]);
        this.h.execute("insert into users (id, name) values (?, ?)", new Object[]{1, "Alice"});
        this.h.execute("insert into users (id, name) values (?, ?)", new Object[]{2, "Bob"});
    }

    @Test
    public void testImmutableList() throws Exception {
        org.assertj.core.api.Assertions.assertThat(((UserDao)this.h.attach(UserDao.class)).list()).containsExactly((Object[])new User[]{new User(1, "Alice"), new User(2, "Bob")});
    }

    @Test
    public void testOptional() throws Exception {
        Assertions.assertThat(((UserDao)this.h.attach(UserDao.class)).getById(1L)).contains((Object)new User(1, "Alice"));
    }

    public static class User {
        private final int id;
        private final String name;

        public User(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.id == user.id && Objects.equals(this.name, user.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "User{id=" + this.id + ", name='" + this.name + '\'' + '}';
        }
    }

    @RegisterConstructorMapper(value=User.class)
    public static interface UserDao {
        @SqlQuery(value="select * from users order by name")
        public ImmutableList<User> list();

        @SqlQuery(value="select * from users where id = :id")
        public Optional<User> getById(long var1);
    }
}

