/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestInClauseExpansion {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugins();
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testInClauseExpansion() throws Exception {
        this.handle.execute("insert into something (name, id) values ('Brian', 1), ('Jeff', 2), ('Tom', 3)", new Object[0]);
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat(dao.findIdsForNames(Arrays.asList(1, 2))).containsExactly((Object[])new String[]{"Brian", "Jeff"});
    }

    public static interface DAO {
        @SqlQuery(value="select name from something where id in (<names>)")
        public ImmutableSet<String> findIdsForNames(@BindList List<Integer> var1);
    }
}

