/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindTime;
import org.jdbi.v3.sqlobject.MockClock;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.locator.UseClasspathSqlLocator;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestInheritedAnnotations {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private MockClock mockClock = new MockClock();

    @Before
    public void setUp() {
        ((BindTime.Config)this.dbRule.getJdbi().getConfig(BindTime.Config.class)).clock = this.mockClock;
        Handle handle = this.dbRule.getSharedHandle();
        handle.execute("CREATE TABLE characters (id INT, name VARCHAR, created TIMESTAMP, modified TIMESTAMP)", new Object[0]);
    }

    @Test
    public void testCrud() throws Exception {
        Instant inserted = this.mockClock.instant();
        CharacterDao dao = (CharacterDao)this.dbRule.getJdbi().onDemand(CharacterDao.class);
        dao.insert(new Character(1, "Moiraine Sedai"));
        Assertions.assertThat(dao.findById(1)).contains((Object)new Character(1, "Moiraine Sedai", inserted, inserted));
        Instant modified = this.mockClock.advance(10L, ChronoUnit.SECONDS);
        Assertions.assertThat((Instant)inserted).isBefore(modified);
        dao.update(new Character(1, "Mistress Alys"));
        Assertions.assertThat(dao.findById(1)).contains((Object)new Character(1, "Mistress Alys", inserted, modified));
        dao.delete(1);
        Assertions.assertThat(dao.findById(1)).isEmpty();
    }

    public static class Character {
        public final int id;
        public final String name;
        private final Instant created;
        private final Instant modified;

        public Character(int id, String name) {
            this(id, name, null, null);
        }

        @JdbiConstructor
        public Character(int id, String name, Instant created, Instant modified) {
            this.id = id;
            this.name = name;
            this.created = created;
            this.modified = modified;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Instant getCreated() {
            return this.created;
        }

        public Instant getModified() {
            return this.modified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Character character = (Character)o;
            return this.id == character.id && Objects.equals(this.name, character.name) && Objects.equals(this.created, character.created) && Objects.equals(this.modified, character.modified);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.created, this.modified);
        }

        public String toString() {
            return "Character{id=" + this.id + ", name='" + this.name + '\'' + ", created=" + this.created + ", modified=" + this.modified + '}';
        }
    }

    @RegisterConstructorMapper(value=Character.class)
    public static interface CharacterDao
    extends CrudDao<Character, Integer> {
    }

    @UseClasspathSqlLocator
    @BindTime
    public static interface CrudDao<T, ID> {
        @SqlUpdate
        public void insert(@BindBean T var1);

        @SqlQuery
        public Optional<T> findById(ID var1);

        @SqlUpdate
        public void update(@BindBean T var1);

        @SqlUpdate
        public void delete(ID var1);
    }
}

