/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestMistypedNamedParameter {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Dao dao;

    @Before
    public void setUp() throws Exception {
        this.dao = (Dao)this.dbRule.getSharedHandle().attach(Dao.class);
        this.dbRule.getSharedHandle().useTransaction(h -> {
            h.execute("insert into something (id, name) values (1, 'Alice')", new Object[0]);
            h.execute("insert into something (id, name) values (2, 'Bob')", new Object[0]);
            h.execute("insert into something (id, name) values (3, 'Charles')", new Object[0]);
        });
    }

    @Test
    public void testWarnAboutUnmatchedBinding() throws Exception {
        Assertions.assertThatExceptionOfType(UnableToExecuteStatementException.class).isThrownBy(() -> this.dao.deleteSomething(2)).satisfies(e -> Assertions.assertThat((String)e.getMessage()).startsWith((CharSequence)"Unable to execute. The query doesn't have named parameters, but provided binding"));
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Dao {
        @SqlUpdate(value="delete from something where id = id")
        public void deleteSomething(@Bind(value="id") int var1);
    }
}

