/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.h2.jdbcx.JdbcDataSource;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMixinInterfaces {
    private Jdbi db;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(String.format("jdbc:h2:mem:%s;MVCC=TRUE", UUID.randomUUID()));
        this.db = Jdbi.create((DataSource)ds);
        this.db.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        this.handle = this.db.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testGetHandle() throws Exception {
        WithGetHandle g = (WithGetHandle)this.handle.attach(WithGetHandle.class);
        Handle h = g.getHandle();
        Assertions.assertThat((Object)h).isSameAs((Object)this.handle);
    }

    @Test
    public void testWithHandle() throws Exception {
        WithGetHandle g = (WithGetHandle)this.handle.attach(WithGetHandle.class);
        String name = (String)g.withHandle(handle1 -> {
            handle1.execute("insert into something (id, name) values (8, 'Mike')", new Object[0]);
            return (String)handle1.createQuery("select name from something where id = 8").mapTo(String.class).findOnly();
        });
        Assertions.assertThat((String)name).isEqualTo((Object)"Mike");
    }

    @Test
    public void testUseHandle() throws Exception {
        WithGetHandle g = (WithGetHandle)this.handle.attach(WithGetHandle.class);
        g.useHandle(handle -> handle.execute("insert into something(id, name) values (9, 'James')", new Object[0]));
        Assertions.assertThat((String)((String)this.handle.createQuery("select name from something where id = 9").mapTo(String.class).findOnly())).isEqualTo((Object)"James");
    }

    @Test
    public void testBeginAndCommitTransaction() throws Exception {
        TransactionStuff txl = (TransactionStuff)this.handle.attach(TransactionStuff.class);
        txl.insert(8L, "Mike");
        txl.begin();
        txl.updateName(8L, "Miker");
        Assertions.assertThat((String)txl.byId(8L).getName()).isEqualTo((Object)"Miker");
        txl.rollback();
        Assertions.assertThat((String)txl.byId(8L).getName()).isEqualTo((Object)"Mike");
    }

    @Test
    public void testInTransaction() throws Exception {
        TransactionStuff txl = (TransactionStuff)this.handle.attach(TransactionStuff.class);
        txl.insert(7L, "Keith");
        Something s = (Something)txl.inTransaction(h -> h.byId(7L));
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Keith");
    }

    @Test
    public void testInTransactionWithLevel() throws Exception {
        TransactionStuff txl = (TransactionStuff)this.handle.attach(TransactionStuff.class);
        txl.insert(7L, "Keith");
        Something s = (Something)txl.inTransaction(TransactionIsolationLevel.SERIALIZABLE, conn -> {
            Assertions.assertThat((Comparable)conn.getHandle().getTransactionIsolationLevel()).isEqualTo((Object)TransactionIsolationLevel.SERIALIZABLE);
            return conn.byId(7L);
        });
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Keith");
    }

    @Test
    public void testTransactionIsolationActuallyHappens() throws Exception {
        TransactionStuff txl = (TransactionStuff)this.handle.attach(TransactionStuff.class);
        this.db.useExtension(TransactionStuff.class, tx2 -> {
            txl.insert(8L, "Mike");
            txl.begin();
            txl.updateName(8L, "Miker");
            Assertions.assertThat((String)txl.byId(8L).getName()).isEqualTo((Object)"Miker");
            Assertions.assertThat((String)tx2.byId(8L).getName()).isEqualTo((Object)"Mike");
            txl.commit();
            Assertions.assertThat((String)tx2.byId(8L).getName()).isEqualTo((Object)"Miker");
        });
    }

    @Test
    public void testJustJdbiTransactions() throws Exception {
        try (Handle h1 = this.db.open();
             Handle h2 = this.db.open();){
            h1.execute("insert into something (id, name) values (8, 'Mike')", new Object[0]);
            h1.begin();
            h1.execute("update something set name = 'Miker' where id = 8", new Object[0]);
            Assertions.assertThat((String)((String)h2.createQuery("select name from something where id = 8").mapTo(String.class).findOnly())).isEqualTo((Object)"Mike");
            h1.commit();
        }
    }

    private static interface TransactionStuff
    extends Transactional<TransactionStuff> {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="update something set name = :name where id = :id")
        public void updateName(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }

    private static interface WithGetHandle
    extends SqlObject {
    }
}

