/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.FetchSize;
import org.jdbi.v3.sqlobject.customizer.MaxRows;
import org.jdbi.v3.sqlobject.customizer.QueryTimeOut;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestModifiers {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
        this.handle.registerRowMapper((RowMapper)new SomethingMapper());
    }

    @Test
    public void testFetchSizeAsArgOnlyUsefulWhenSteppingThroughDebuggerSadly() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAll(1);
        Assertions.assertThat(things).hasSize(3);
    }

    @Test
    public void testFetchSizeOnMethodOnlyUsefulWhenSteppingThroughDebuggerSadly() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAll();
        Assertions.assertThat(things).hasSize(3);
    }

    @Test
    public void testMaxSizeOnMethod() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAllWithMaxRows();
        Assertions.assertThat(things).hasSize(1);
    }

    @Test
    public void testMaxSizeOnParam() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAllWithMaxRows(2);
        Assertions.assertThat(things).hasSize(2);
    }

    @Test
    public void testQueryTimeOutOnMethodOnlyUsefulWhenSteppingThroughDebuggerSadly() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAllWithQueryTimeOut();
        Assertions.assertThat(things).hasSize(3);
    }

    @Test
    public void testQueryTimeOutOnParamOnlyUsefulWhenSteppingThroughDebuggerSadly() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(14L, "Tom");
        s.insert(15L, "JFA");
        s.insert(16L, "Sunny");
        List<Something> things = s.findAllWithQueryTimeOut(2);
        Assertions.assertThat(things).hasSize(3);
    }

    @Test
    public void testIsolationLevel() throws Exception {
        this.dbRule.getJdbi().useExtension(Spiffy.class, spiffy -> this.dbRule.getJdbi().useExtension(IsoLevels.class, iso -> {
            spiffy.begin();
            spiffy.insert(1L, "Tom");
            Something tom = iso.findById(1);
            Assertions.assertThat((Object)tom).isNotNull();
            spiffy.rollback();
            Something notTom = iso.findById(1);
            Assertions.assertThat((Object)notTom).isNull();
        }));
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface IsoLevels {
        @Transaction(value=TransactionIsolationLevel.READ_UNCOMMITTED)
        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy
    extends Transactional<Spiffy> {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something byId(@Bind(value="id") long var1);

        @SqlQuery(value="select id, name from something")
        public List<Something> findAll(@FetchSize(value=1) int var1);

        @SqlQuery(value="select id, name from something")
        @FetchSize(value=2)
        public List<Something> findAll();

        @SqlQuery(value="select id, name from something")
        public List<Something> findAllWithMaxRows(@MaxRows int var1);

        @SqlQuery(value="select id, name from something")
        @MaxRows(value=1)
        public List<Something> findAllWithMaxRows();

        @SqlQuery(value="select id, name from something")
        public List<Something> findAllWithQueryTimeOut(@QueryTimeOut(value=1) int var1);

        @SqlQuery(value="select id, name from something")
        @QueryTimeOut(value=1)
        public List<Something> findAllWithQueryTimeOut();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

