/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.Connection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.h2.jdbcx.JdbcDataSource;
import org.jdbi.v3.core.ConnectionException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindSomething;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestNewApiOnDbiAndHandle {
    private Jdbi db;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.db = Jdbi.create((DataSource)ds);
        this.db.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        this.db.registerRowMapper((RowMapper)new SomethingMapper());
        this.handle = this.db.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testOpenNewSpiffy() throws Exception {
        AtomicReference c = new AtomicReference();
        this.db.useExtension(Spiffy.class, spiffy -> {
            spiffy.insert(new Something(1, "Tim"));
            spiffy.insert(new Something(2, "Diego"));
            Assertions.assertThat((String)spiffy.findNameById(2)).isEqualTo((Object)"Diego");
            c.set(spiffy.getHandle().getConnection());
        });
        Assertions.assertThat((boolean)((Connection)c.get()).isClosed()).isTrue();
    }

    @Test
    public void testOnDemandSpiffy() throws Exception {
        Spiffy spiffy = (Spiffy)this.db.onDemand(Spiffy.class);
        spiffy.insert(new Something(1, "Tim"));
        spiffy.insert(new Something(2, "Diego"));
        Assertions.assertThat((String)spiffy.findNameById(2)).isEqualTo((Object)"Diego");
    }

    @Test
    public void testAttach() throws Exception {
        Spiffy spiffy = (Spiffy)this.handle.attach(Spiffy.class);
        spiffy.insert(new Something(1, "Tim"));
        spiffy.insert(new Something(2, "Diego"));
        Assertions.assertThat((String)spiffy.findNameById(2)).isEqualTo((Object)"Diego");
    }

    @Test
    public void testCorrectExceptionIfUnableToConnectOnDemand() {
        Assertions.assertThatThrownBy(() -> ((Spiffy)Jdbi.create((String)"jdbc:mysql://invalid.invalid/test", (String)"john", (String)"scott").installPlugin((JdbiPlugin)new SqlObjectPlugin()).onDemand(Spiffy.class)).findNameById(1)).isInstanceOf(ConnectionException.class);
    }

    @Test
    public void testCorrectExceptionIfUnableToConnectOnOpen() {
        Assertions.assertThatThrownBy(() -> {
            Spiffy cfr_ignored_0 = (Spiffy)Jdbi.create((String)"jdbc:mysql://invalid.invalid/test", (String)"john", (String)"scott").installPlugin((JdbiPlugin)new SqlObjectPlugin()).open().attach(Spiffy.class);
        }).isInstanceOf(ConnectionException.class);
    }

    @Test
    public void testCorrectExceptionIfUnableToConnectOnAttach() {
        Assertions.assertThatThrownBy(() -> {
            Spiffy cfr_ignored_0 = (Spiffy)Jdbi.create((String)"jdbc:mysql://invalid.invalid/test", (String)"john", (String)"scott").installPlugin((JdbiPlugin)new SqlObjectPlugin()).open().attach(Spiffy.class);
        }).isInstanceOf(ConnectionException.class);
    }

    public static interface Spiffy
    extends SqlObject {
        @SqlUpdate(value="insert into something (id, name) values (:it.id, :it.name)")
        public void insert(@BindSomething(value="it") Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }
}

