/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestNull {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private DAO dao;

    @Before
    public void setUp() throws Exception {
        this.dao = (DAO)this.dbRule.getSharedHandle().attach(DAO.class);
        this.dao.insert(1L, "brian");
        this.dao.insert(2L, null);
    }

    @Test
    public void testNotNullResult() {
        Assertions.assertThat((String)this.dao.findNameById(1L)).isEqualTo((Object)"brian");
    }

    @Test
    public void testNullResult() {
        Assertions.assertThat((String)this.dao.findNameById(2L)).isNull();
    }

    @Test
    public void testNoResult() {
        Assertions.assertThat((String)this.dao.findNameById(3L)).isNull();
    }

    public static interface DAO {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") long var1);
    }
}

