/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestObjectMethods {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testToString() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((String)dao.toString()).contains(new CharSequence[]{DAO.class.getName()});
    }

    @Test
    public void testEquals() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((Object)dao).isEqualTo((Object)dao);
    }

    @Test
    public void testNotEquals() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        DAO oad = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((Object)dao).isNotEqualTo((Object)oad);
    }

    @Test
    public void testHashCodeDiff() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        DAO oad = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((int)dao.hashCode()).isNotEqualTo(oad.hashCode());
    }

    @Test
    public void testHashCodeMatch() throws Exception {
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat((int)dao.hashCode()).isEqualTo(dao.hashCode());
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface DAO {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

