/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.h2.jdbcx.JdbcDataSource;
import org.jdbi.v3.core.CloseException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.locator.UseClasspathSqlLocator;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestOnDemandSqlObject {
    private Jdbi db;
    private Handle handle;
    private final HandleTracker tracker = new HandleTracker();
    private JdbcDataSource ds;

    @Before
    public void setUp() throws Exception {
        this.ds = new JdbcDataSource();
        this.ds.setURL(String.format("jdbc:h2:mem:%s;MVCC=TRUE", UUID.randomUUID()));
        this.db = Jdbi.create((DataSource)this.ds);
        this.db.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        this.handle = this.db.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
        this.db.installPlugin((JdbiPlugin)this.tracker);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    @Test
    public void testAPIWorks() throws Exception {
        Spiffy s = (Spiffy)this.db.onDemand(Spiffy.class);
        s.insert(7L, "Bill");
        String bill = (String)this.db.open().createQuery("select name from something where id = 7").mapTo(String.class).findOnly();
        Assertions.assertThat((String)bill).isEqualTo((Object)"Bill");
    }

    @Test
    public void testExceptionOnClose() throws Exception {
        JdbiPlugin plugin = new JdbiPlugin(){

            public Handle customizeHandle(Handle handle) {
                Handle h = (Handle)Mockito.spy((Object)handle);
                Mockito.when((Object)h.createUpdate(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new TransactionException("connection reset")});
                ((Handle)Mockito.doThrow((Throwable[])new Throwable[]{new CloseException("already closed", null)}).when((Object)h)).close();
                return h;
            }
        };
        this.db.installPlugin(plugin);
        Spiffy s = (Spiffy)this.db.onDemand(Spiffy.class);
        Assertions.assertThatThrownBy(() -> s.insert(1L, "Tom")).isInstanceOf(TransactionException.class);
    }

    @Test
    public void testIteratorCloseHandleOnError() throws Exception {
        Spiffy s = (Spiffy)this.db.onDemand(Spiffy.class);
        Assertions.assertThatExceptionOfType(JdbiException.class).isThrownBy(s::crashNow);
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testIteratorClosedOnReadError() throws Exception {
        Spiffy spiffy = (Spiffy)this.db.onDemand(Spiffy.class);
        spiffy.insert(1L, "Tom");
        Iterator<Something> i = spiffy.crashOnFirstRead();
        Assertions.assertThatExceptionOfType(JdbiException.class).isThrownBy(i::next);
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testIteratorClosedIfEmpty() throws Exception {
        Spiffy spiffy = (Spiffy)this.db.onDemand(Spiffy.class);
        spiffy.findAll();
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testIteratorPrepatureClose() throws Exception {
        Spiffy spiffy = (Spiffy)this.db.onDemand(Spiffy.class);
        spiffy.insert(1L, "Tom");
        ResultIterator<Something> all = spiffy.findAll();
        Throwable throwable = null;
        if (all != null) {
            if (throwable != null) {
                try {
                    all.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                all.close();
            }
        }
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testSqlFromExternalFileWorks() throws Exception {
        Spiffy spiffy = (Spiffy)this.db.onDemand(Spiffy.class);
        ExternalSql external = (ExternalSql)this.db.onDemand(ExternalSql.class);
        spiffy.insert(1L, "Tom");
        spiffy.insert(2L, "Sam");
        List<Something> all = external.findAll();
        Assertions.assertThat(all).hasSize(2);
    }

    static class HandleTracker
    implements JdbiPlugin {
        final List<Handle> openedHandle = new ArrayList<Handle>();

        HandleTracker() {
        }

        public Handle customizeHandle(Handle handle) {
            this.openedHandle.add(handle);
            return handle;
        }

        boolean hasOpenedHandle() throws SQLException {
            for (Handle h : this.openedHandle) {
                if (h.getConnection().isClosed()) continue;
                return true;
            }
            return false;
        }
    }

    public static class CrashingMapper
    implements RowMapper<Something> {
        public Something map(ResultSet r, StatementContext ctx) throws SQLException {
            throw new SQLException("fake protocol error");
        }
    }

    @UseClasspathSqlLocator
    public static interface ExternalSql {
        @SqlQuery(value="all-something")
        @UseRowMapper(value=SomethingMapper.class)
        public List<Something> findAll();
    }

    public static interface TransactionStuff
    extends Transactional<TransactionStuff> {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="update something set name = :name where id = :id")
        public void updateName(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }

    public static interface Spiffy {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlQuery(value="select name, id from something")
        @UseRowMapper(value=SomethingMapper.class)
        public ResultIterator<Something> findAll();

        @SqlQuery(value="select * from crash now")
        @UseRowMapper(value=SomethingMapper.class)
        public Iterator<Something> crashNow();

        @SqlQuery(value="select name, id from something")
        @UseRowMapper(value=CrashingMapper.class)
        public Iterator<Something> crashOnFirstRead();
    }
}

