/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.JdbiRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestOptional {
    @Rule
    public JdbiRule dbRule = JdbiRule.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private DAO dao;

    @Before
    public void setUp() throws Exception {
        this.dbRule.getHandle().execute("create table something (id identity primary key, name varchar(50))", new Object[0]);
        this.dao = (DAO)this.dbRule.attach(DAO.class);
        this.dao.insert(1L, "brian");
        this.dao.insert(2L, "eric");
    }

    @Test
    public void testOptionalParameterPresent() {
        Assertions.assertThat(this.dao.findIds(Optional.of("brian"))).containsExactly((Object[])new Integer[]{1});
    }

    @Test
    public void testOptionalPresentAbsent() {
        Assertions.assertThat(this.dao.findIds(Optional.empty())).containsExactly((Object[])new Integer[]{1, 2});
    }

    @Test
    public void testOptionalReturnPresent() {
        Assertions.assertThat(this.dao.findNameById(1L)).contains((Object)"brian");
    }

    @Test
    public void testOptionalReturnAbsent() {
        Assertions.assertThat(this.dao.findNameById(3L)).isEmpty();
    }

    @Test
    public void testNullReturnsAbsent() {
        this.dao.insert(3L, null);
        Assertions.assertThat(this.dao.findNameById(3L)).isEmpty();
    }

    @Test
    public void testOptionalReturnMultiple() {
        Assertions.assertThatThrownBy(this.dao::findMultiple).isInstanceOf(IllegalStateException.class);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface DAO {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlQuery(value="select id from something where :name is null or name = :name order by id")
        public List<Integer> findIds(@Bind(value="name") Optional<String> var1);

        @SqlQuery(value="select name from something where id = :id")
        public Optional<String> findNameById(@Bind long var1);

        @SqlQuery(value="select name from something")
        public Optional<String> findMultiple();
    }
}

