/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.rule.PgDatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.OutParameters;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.OutParameter;
import org.jdbi.v3.sqlobject.customizer.OutParameterList;
import org.jdbi.v3.sqlobject.statement.SqlCall;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestOutParameterAnnotation {
    @Rule
    public PgDatabaseRule dbRule = new PgDatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi db;

    @Before
    public void setUp() throws Exception {
        this.db = this.dbRule.getJdbi();
        this.db.useHandle(h -> {
            h.execute("CREATE FUNCTION set100(OUT outparam INT) AS $$ BEGIN outparam := 100; END; $$ LANGUAGE plpgsql", new Object[0]);
            h.execute("CREATE FUNCTION swap(IN a INT, IN b INT, OUT c INT, OUT d INT) AS $$ BEGIN c := b; d := a; END; $$ LANGUAGE plpgsql", new Object[0]);
        });
    }

    @Test
    public void testOutParameter() {
        MyDao myDao = (MyDao)this.db.onDemand(MyDao.class);
        OutParameters outParameters = myDao.callStoredProc();
        Assertions.assertThat((Integer)outParameters.getInt("outparam")).isEqualTo(100);
    }

    @Test
    public void testMultipleOutParameters() {
        MyDao myDao = (MyDao)this.db.onDemand(MyDao.class);
        OutParameters outParameters = myDao.callMultipleOutParameters(1, 9);
        Assertions.assertThat((Integer)outParameters.getInt("c")).isEqualTo(9);
        Assertions.assertThat((Integer)outParameters.getInt("d")).isEqualTo(1);
    }

    public static interface MyDao {
        @SqlCall(value="{call set100(:outparam)}")
        @OutParameter(name="outparam", sqlType=4)
        public OutParameters callStoredProc();

        @SqlCall(value="{call swap(:a, :b, :c, :d)}")
        @OutParameterList(value={@OutParameter(name="c", sqlType=4), @OutParameter(name="d", sqlType=4)})
        public OutParameters callMultipleOutParameters(int var1, int var2);
    }
}

