/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.guava.GuavaPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestPaging {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new GuavaPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void pagingExample() throws Exception {
        Sql sql = (Sql)this.handle.attach(Sql.class);
        int[] rs = sql.insert(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13), Arrays.asList("Ami", "Brian", "Cora", "David", "Eric", "Fernando", "Greta", "Holly", "Inigo", "Joy", "Keith", "Lisa", "Molly"));
        Assertions.assertThat((int[])rs).hasSize(13).containsOnly(new int[]{1});
        ImmutableList<Something> pageOne = sql.loadPage(-1, 5);
        Assertions.assertThat(pageOne).containsExactly((Object[])new Something[]{new Something(1, "Ami"), new Something(2, "Brian"), new Something(3, "Cora"), new Something(4, "David"), new Something(5, "Eric")});
        ImmutableList<Something> pageTwo = sql.loadPage(((Something)pageOne.get(pageOne.size() - 1)).getId(), 5);
        Assertions.assertThat(pageTwo).containsExactly((Object[])new Something[]{new Something(6, "Fernando"), new Something(7, "Greta"), new Something(8, "Holly"), new Something(9, "Inigo"), new Something(10, "Joy")});
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Sql {
        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] insert(@Bind(value="id") Iterable<Integer> var1, @Bind(value="name") Iterable<String> var2);

        @SqlQuery(value="select id, name from something where id > :end_of_last_page order by id limit :size")
        public ImmutableList<Something> loadPage(@Bind(value="end_of_last_page") int var1, @Bind(value="size") int var2);
    }
}

