/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.PgDatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestPostgresBugs {
    @Rule
    public PgDatabaseRule dbRule = new PgDatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Before
    public void setUp() throws Exception {
        this.dbRule.getJdbi().useHandle(handle -> {
            handle.execute("create table if not exists something (id int primary key, name varchar(100))", new Object[0]);
            handle.execute("delete from something", new Object[0]);
        });
    }

    @Test
    public void testConnected() throws Exception {
        int four = (Integer)this.dbRule.getJdbi().withHandle(handle -> (Integer)handle.createQuery("select 2 + 2").mapTo(Integer.class).findOnly());
        Assertions.assertThat((int)four).isEqualTo(4);
    }

    @Test
    public void testTransactions() throws Exception {
        Dao dao = (Dao)this.dbRule.getJdbi().onDemand(Dao.class);
        Something s = dao.insertAndFetch(1, "Brian");
        Assertions.assertThat((Object)s).isEqualTo((Object)new Something(1, "Brian"));
    }

    @Test
    public void testExplicitTransaction() throws Exception {
        Dao dao = (Dao)this.dbRule.getJdbi().onDemand(Dao.class);
        Something s = (Something)dao.inTransaction(transactional -> {
            transactional.insert(1, "Brian");
            return transactional.findById(1);
        });
        Assertions.assertThat((Object)s).isEqualTo((Object)new Something(1, "Brian"));
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Dao
    extends Transactional<Dao> {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        @Transaction(value=TransactionIsolationLevel.READ_COMMITTED)
        default public Something insertAndFetch(int id, String name) {
            this.insert(id, name);
            return this.findById(id);
        }

        @Transaction
        default public Something failed(int id, String name) throws IOException {
            this.insert(id, name);
            throw new IOException("woof");
        }
    }
}

