/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestPrimitiveQueryResult {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    @Rule
    public ExpectedException exception = ExpectedException.none();
    PrimitiveDao dao;

    @Before
    public void setUp() {
        this.dao = (PrimitiveDao)this.dbRule.getSharedHandle().attach(PrimitiveDao.class);
        this.dao.insert(1, "foo");
    }

    @Test
    public void testBoolean() {
        Assertions.assertThat((boolean)this.dao.getBoolean(1)).isTrue();
        this.exception.expect(IllegalStateException.class);
        this.dao.getBoolean(2);
    }

    @Test
    public void testByte() {
        Assertions.assertThat((byte)this.dao.getByte(1)).isEqualTo((byte)1);
        this.exception.expect(IllegalStateException.class);
        this.dao.getByte(2);
    }

    @Test
    public void testChar() {
        Assertions.assertThat((char)this.dao.getChar(1)).isEqualTo('a');
        this.exception.expect(IllegalStateException.class);
        this.dao.getChar(2);
    }

    @Test
    public void testShort() {
        Assertions.assertThat((short)this.dao.getShort(1)).isEqualTo((short)1);
        this.exception.expect(IllegalStateException.class);
        this.dao.getShort(2);
    }

    @Test
    public void testInt() {
        Assertions.assertThat((int)this.dao.getInt(1)).isEqualTo(1);
        this.exception.expect(IllegalStateException.class);
        this.dao.getInt(2);
    }

    @Test
    public void testLong() {
        Assertions.assertThat((long)this.dao.getLong(1)).isEqualTo(1L);
        this.exception.expect(IllegalStateException.class);
        this.dao.getLong(2);
    }

    @Test
    public void testFloat() {
        Assertions.assertThat((float)this.dao.getFloat(1)).isEqualTo(1.0f);
        this.exception.expect(IllegalStateException.class);
        this.dao.getFloat(2);
    }

    @Test
    public void testDouble() {
        Assertions.assertThat((double)this.dao.getDouble(1)).isEqualTo(1.0);
        this.exception.expect(IllegalStateException.class);
        this.dao.getDouble(2);
    }

    public static interface PrimitiveDao {
        @SqlUpdate(value="insert into something(id, name) values (:id, :name)")
        public void insert(int var1, String var2);

        @SqlQuery(value="select 1 from something where id = :id")
        public boolean getBoolean(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public byte getByte(int var1);

        @SqlQuery(value="select 'a' from something where id = :id")
        public char getChar(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public short getShort(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public int getInt(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public long getLong(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public float getFloat(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public double getDouble(int var1);
    }
}

