/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.rule.PgDatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.junit.Rule;
import org.junit.Test;

public class TestReadOnly {
    @Rule
    public PgDatabaseRule db = new PgDatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testHandleReadOnly() throws Exception {
        try (Handle h = this.db.openHandle();){
            Assertions.assertThat((boolean)h.isReadOnly()).isFalse();
            Assertions.assertThat((boolean)h.getConnection().isReadOnly()).isFalse();
            h.setReadOnly(true);
            Assertions.assertThat((boolean)h.isReadOnly()).isTrue();
            Assertions.assertThat((boolean)h.getConnection().isReadOnly()).isTrue();
        }
    }

    @Test
    public void testSqlObjectReadOnly() throws Exception {
        try (Handle h = this.db.openHandle();){
            RODao dao = (RODao)h.attach(RODao.class);
            Assertions.assertThat((boolean)h.isReadOnly()).isFalse();
            Assertions.assertThat((boolean)dao.verifyReadOnly()).isTrue();
            Assertions.assertThat((boolean)h.isReadOnly()).isFalse();
        }
    }

    @Test
    public void testReadOnlyInner() {
        try (Handle h = this.db.openHandle();){
            RODao dao = (RODao)h.attach(RODao.class);
            dao.writeTxn(() -> dao.readTxn(() -> {}));
        }
    }

    @Test
    public void testReadOnlyOuter() {
        try (Handle h = this.db.openHandle();){
            RODao dao = (RODao)h.attach(RODao.class);
            Assertions.assertThatThrownBy(() -> dao.readTxn(() -> dao.writeTxn(() -> {}))).isInstanceOf(TransactionException.class);
        }
    }

    private static interface RODao
    extends SqlObject {
        @Transaction(readOnly=true)
        default public boolean verifyReadOnly() throws SQLException {
            Handle h = this.getHandle();
            if (h.isReadOnly() != h.getConnection().isReadOnly()) {
                throw new AssertionError((Object)"didn't set");
            }
            return h.isReadOnly();
        }

        @Transaction(readOnly=false)
        default public void writeTxn(Runnable r) {
            r.run();
        }

        @Transaction(readOnly=true)
        default public void readTxn(Runnable r) {
            r.run();
        }
    }
}

