/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.h2.jdbcx.JdbcDataSource;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestReentrancy {
    private Jdbi db;
    private Handle handle;

    @Test
    public void testGetHandleProvidesSeperateHandle() throws Exception {
        TheBasics dao = (TheBasics)this.db.onDemand(TheBasics.class);
        Handle h = dao.getHandle();
        Assertions.assertThatThrownBy(() -> h.execute("insert into something (id, name) values (1, 'Stephen')", new Object[0])).isInstanceOf(UnableToCreateStatementException.class);
    }

    @Test
    public void testHandleReentrant() throws Exception {
        TheBasics dao = (TheBasics)this.db.onDemand(TheBasics.class);
        dao.withHandle(handle1 -> {
            dao.insert(new Something(7, "Martin"));
            handle1.createQuery("SELECT 1").mapToMap().list();
            return null;
        });
    }

    @Test
    public void testTxnReentrant() throws Exception {
        TheBasics dao = (TheBasics)this.db.onDemand(TheBasics.class);
        dao.withHandle(handle1 -> {
            handle1.useTransaction(h -> {
                dao.insert(new Something(1, "x"));
                List rs = h.createQuery("select name from something where id = 1").mapTo(String.class).list();
                Assertions.assertThat((List)rs).hasSize(1);
                h.createQuery("SELECT 1").mapTo(Integer.TYPE).list();
            });
            return null;
        });
    }

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(String.format("jdbc:h2:mem:%s;MVCC=TRUE", UUID.randomUUID()));
        this.db = Jdbi.create((DataSource)ds);
        this.db.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        this.db.registerRowMapper((RowMapper)new SomethingMapper());
        this.handle = this.db.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    private static interface TheBasics
    extends SqlObject {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@BindBean Something var1);
    }
}

