/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Type;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactories;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestRegisterArgumentFactory {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi db;

    @Before
    public void setUp() throws Exception {
        this.db = this.dbRule.getJdbi();
    }

    @Test
    public void testSingleAnnotation() throws Exception {
        this.db.useExtension(Waffle.class, w -> {
            w.insert(1, new Name("Brian", "McCallister"));
            Assertions.assertThat((String)w.findName(1)).isEqualTo((Object)"Brian McCallister");
        });
    }

    @Test
    public void testMultipleAnnotations() throws Exception {
        this.db.useExtension(ShortStack.class, s -> {
            s.insert(1, new Name("George", "Takei"));
            Assertions.assertThat((String)s.findName(1)).isEqualTo((Object)"George Takei");
        });
    }

    public static class Name {
        private final String first;
        private final String last;

        public Name(String first, String last) {
            this.first = first;
            this.last = last;
        }

        public String getFullName() {
            return this.first + " " + this.last;
        }

        public String toString() {
            return "<Name first=" + this.first + " last=" + this.last + " >";
        }
    }

    public static class NameAF
    implements ArgumentFactory {
        public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
            if (expectedType == Name.class || value instanceof Name) {
                Name nameValue = (Name)value;
                return Optional.of((position, statement, ctx1) -> statement.setString(position, nameValue.getFullName()));
            }
            return Optional.empty();
        }
    }

    public static class LazyAF
    implements ArgumentFactory {
        public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
            return Optional.empty();
        }
    }

    @RegisterArgumentFactories(value={@RegisterArgumentFactory(value=NameAF.class), @RegisterArgumentFactory(value=LazyAF.class)})
    public static interface ShortStack {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") Name var2);

        @SqlQuery(value="select name from something where id = :id")
        public String findName(@Bind(value="id") int var1);
    }

    @RegisterArgumentFactory(value=NameAF.class)
    public static interface Waffle {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") Name var2);

        @SqlQuery(value="select name from something where id = :id")
        public String findName(@Bind(value="id") int var1);
    }
}

